/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of vines.
 */
public abstract class Vines extends AddressFamily {

    /**
     * Returns the attribute vines.
     *
     * @return vines value of vines
     */
    public static String vinesToString() {
        return "vines";
    }

    /**
     * Returns the object of vines fromString input String vines.
     *
     * @param valInString value of input String
     * @return vines
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("vines")) {
            return Vines.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}