/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.timervaluemilliseconds.TimerValueMillisecondsUnion;
import java.util.Objects;

/**
 * Represents the implementation of timerValueMilliseconds.
 */
public final class TimerValueMilliseconds {

    private TimerValueMillisecondsUnion union;

    /**
     * Creates an instance of timerValueMilliseconds.
     */
    private TimerValueMilliseconds() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public TimerValueMilliseconds(TimerValueMillisecondsUnion union) {
        this.union = union;
    }

    /**
     * Returns the object of timerValueMilliseconds for type union.
     *
     * @param value value of timerValueMilliseconds for type union
     * @return timerValueMilliseconds for type union
     */
    public static TimerValueMilliseconds of(TimerValueMillisecondsUnion value) {
        return new TimerValueMilliseconds(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public TimerValueMillisecondsUnion union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(TimerValueMillisecondsUnion union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TimerValueMilliseconds) {
            TimerValueMilliseconds other = (TimerValueMilliseconds) obj;
            return
                Objects.deepEquals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of timerValueMilliseconds fromString input String timerValueMilliseconds.
     *
     * @param valInString value of input String
     * @return timerValueMilliseconds
     */
    public static TimerValueMilliseconds fromString(String valInString) {
        try {
            TimerValueMillisecondsUnion tmpVal = TimerValueMillisecondsUnion.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
