/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes.routetargettype.RouteTargetTypeEnum;
import java.util.Objects;

/**
 * Represents the implementation of routeTargetType.
 */
public final class RouteTargetType {

    private RouteTargetTypeEnum enumeration;

    /**
     * Creates an instance of routeTargetType.
     */
    private RouteTargetType() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public RouteTargetType(RouteTargetTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of routeTargetType for type enumeration.
     *
     * @param value value of routeTargetType for type enumeration
     * @return routeTargetType for type enumeration
     */
    public static RouteTargetType of(RouteTargetTypeEnum value) {
        return new RouteTargetType(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public RouteTargetTypeEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(RouteTargetTypeEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouteTargetType) {
            RouteTargetType other = (RouteTargetType) obj;
            return
                Objects.deepEquals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of routeTargetType fromString input String routeTargetType.
     *
     * @param valInString value of input String
     * @return routeTargetType
     */
    public static RouteTargetType fromString(String valInString) {
        try {
            RouteTargetTypeEnum tmpVal = RouteTargetTypeEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
