/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of mtV6.
 */
public abstract class MtV6 extends AddressFamily {

    /**
     * Returns the attribute mt-v6.
     *
     * @return mt-v6 value of mt-v6
     */
    public static String mtV6ToString() {
        return "mt-v6";
    }

    /**
     * Returns the object of mtV6 fromString input String mtV6.
     *
     * @param valInString value of input String
     * @return mtV6
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("mt-v6")) {
            return MtV6.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}