/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of mplsTpSectionEid.
 */
public abstract class MplsTpSectionEid extends AddressFamily {

    /**
     * Returns the attribute mpls-tp-section-eid.
     *
     * @return mpls-tp-section-eid value of mpls-tp-section-eid
     */
    public static String mplsTpSectionEidToString() {
        return "mpls-tp-section-eid";
    }

    /**
     * Returns the object of mplsTpSectionEid fromString input String mplsTpSectionEid.
     *
     * @param valInString value of input String
     * @return mplsTpSectionEid
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("mpls-tp-section-eid")) {
            return MplsTpSectionEid.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}