/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of mplsTpPweEid.
 */
public abstract class MplsTpPweEid extends AddressFamily {

    /**
     * Returns the attribute mpls-tp-pwe-eid.
     *
     * @return mpls-tp-pwe-eid value of mpls-tp-pwe-eid
     */
    public static String mplsTpPweEidToString() {
        return "mpls-tp-pwe-eid";
    }

    /**
     * Returns the object of mplsTpPweEid fromString input String mplsTpPweEid.
     *
     * @param valInString value of input String
     * @return mplsTpPweEid
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("mpls-tp-pwe-eid")) {
            return MplsTpPweEid.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}