/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

import java.util.Objects;

/**
 * Represents the implementation of mplsLabelSpecialPurpose.
 */
public final class MplsLabelSpecialPurpose {

    private Class<? extends MplsLabelSpecialPurposeValue> identityref;

    /**
     * Creates an instance of mplsLabelSpecialPurpose.
     */
    private MplsLabelSpecialPurpose() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public MplsLabelSpecialPurpose(Class<? extends MplsLabelSpecialPurposeValue> identityref) {
        this.identityref = identityref;
    }

    /**
     * Returns the object of mplsLabelSpecialPurpose for type identityref.
     *
     * @param value value of mplsLabelSpecialPurpose for type identityref
     * @return mplsLabelSpecialPurpose for type identityref
     */
    public static MplsLabelSpecialPurpose of(Class<? extends MplsLabelSpecialPurposeValue> value) {
        return new MplsLabelSpecialPurpose(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends MplsLabelSpecialPurposeValue> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends MplsLabelSpecialPurposeValue> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MplsLabelSpecialPurpose) {
            MplsLabelSpecialPurpose other = (MplsLabelSpecialPurpose) obj;
            return
                Objects.deepEquals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (identityref.equals(MplsLabelSpecialPurposeValue.class)) {
            return MplsLabelSpecialPurposeValue.mplsLabelSpecialPurposeValueToString();
        } else if (identityref.equals(Ipv4ExplicitNullLabel.class)) {
            return Ipv4ExplicitNullLabel.ipv4ExplicitNullLabelToString();
        } else if (identityref.equals(RouterAlertLabel.class)) {
            return RouterAlertLabel.routerAlertLabelToString();
        } else if (identityref.equals(Ipv6ExplicitNullLabel.class)) {
            return Ipv6ExplicitNullLabel.ipv6ExplicitNullLabelToString();
        } else if (identityref.equals(ImplicitNullLabel.class)) {
            return ImplicitNullLabel.implicitNullLabelToString();
        } else if (identityref.equals(EntropyLabelIndicator.class)) {
            return EntropyLabelIndicator.entropyLabelIndicatorToString();
        } else if (identityref.equals(GalLabel.class)) {
            return GalLabel.galLabelToString();
        } else if (identityref.equals(OamAlertLabel.class)) {
            return OamAlertLabel.oamAlertLabelToString();
        } else if (identityref.equals(ExtensionLabel.class)) {
            return ExtensionLabel.extensionLabelToString();
        }
        return null;
    }
    /**
     * Returns the object of mplsLabelSpecialPurpose fromString input String mplsLabelSpecialPurpose.
     *
     * @param valInString value of input String
     * @return mplsLabelSpecialPurpose
     */
    public static MplsLabelSpecialPurpose fromString(String valInString) {
        try {
            Class<? extends MplsLabelSpecialPurposeValue> tmpVal = MplsLabelSpecialPurposeValue.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
