/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of implicitNullLabel.
 */
public abstract class ImplicitNullLabel extends MplsLabelSpecialPurposeValue {

    /**
     * Returns the attribute implicit-null-label.
     *
     * @return implicit-null-label value of implicit-null-label
     */
    public static String implicitNullLabelToString() {
        return "implicit-null-label";
    }

    /**
     * Returns the object of implicitNullLabel fromString input String implicitNullLabel.
     *
     * @param valInString value of input String
     * @return implicitNullLabel
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("implicit-null-label")) {
            return ImplicitNullLabel.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}