/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of fcNode.
 */
public abstract class FcNode extends AddressFamily {

    /**
     * Returns the attribute fc-node.
     *
     * @return fc-node value of fc-node
     */
    public static String fcNodeToString() {
        return "fc-node";
    }

    /**
     * Returns the object of fcNode fromString input String fcNode.
     *
     * @param valInString value of input String
     * @return fcNode
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("fc-node")) {
            return FcNode.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}