/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of entropyLabelIndicator.
 */
public abstract class EntropyLabelIndicator extends MplsLabelSpecialPurposeValue {

    /**
     * Returns the attribute entropy-label-indicator.
     *
     * @return entropy-label-indicator value of entropy-label-indicator
     */
    public static String entropyLabelIndicatorToString() {
        return "entropy-label-indicator";
    }

    /**
     * Returns the object of entropyLabelIndicator fromString input String entropyLabelIndicator.
     *
     * @param valInString value of input String
     * @return entropyLabelIndicator
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("entropy-label-indicator")) {
            return EntropyLabelIndicator.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}