/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of e164.
 */
public abstract class E164 extends AddressFamily {

    /**
     * Returns the attribute e164.
     *
     * @return e164 value of e164
     */
    public static String e164ToString() {
        return "e164";
    }

    /**
     * Returns the object of e164 fromString input String e164.
     *
     * @param valInString value of input String
     * @return e164
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("e164")) {
            return E164.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}