/*
 * Copyright 2018-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.actnietfroutingtypes.rev20170227.actnietfroutingtypes;

/**
 * Represents the implementation of bbn1822.
 */
public abstract class Bbn1822 extends AddressFamily {

    /**
     * Returns the attribute bbn1822.
     *
     * @return bbn1822 value of bbn1822
     */
    public static String bbn1822ToString() {
        return "bbn1822";
    }

    /**
     * Returns the object of bbn1822 fromString input String bbn1822.
     *
     * @param valInString value of input String
     * @return bbn1822
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("bbn1822")) {
            return Bbn1822.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}