/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.HashMap;
import java.util.Map;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.runtime.impl.ModelConvertorException;
import org.onosproject.yang.runtime.impl.YobHandler;
import org.onosproject.yang.runtime.impl.YobInnerNodeHandler;
import org.onosproject.yang.runtime.impl.YobLeafListNodeHandler;
import org.onosproject.yang.runtime.impl.YobLeafNodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YobHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(YobHandlerFactory.class);
    private static final Map<DataNode.Type, YobHandler> HANDLER_MAP = new HashMap<DataNode.Type, YobHandler>();

    private YobHandlerFactory() {
        HANDLER_MAP.put(DataNode.Type.SINGLE_INSTANCE_NODE, new YobInnerNodeHandler());
        HANDLER_MAP.put(DataNode.Type.MULTI_INSTANCE_NODE, new YobInnerNodeHandler());
        HANDLER_MAP.put(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE, new YobLeafNodeHandler());
        HANDLER_MAP.put(DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE, new YobLeafListNodeHandler());
    }

    YobHandler getYobHandlerForContext(DataNode.Type type) {
        YobHandler yobHandler = HANDLER_MAP.get(type);
        if (yobHandler == null) {
            log.error("Given data node type is not supported.");
            throw new ModelConvertorException("Given data node type is not supported.");
        }
        return yobHandler;
    }

    static YobHandlerFactory instance() {
        return LazyHolder.INSTANCE;
    }

    static class LazyHolder {
        private static final YobHandlerFactory INSTANCE = new YobHandlerFactory();

        LazyHolder() {
        }
    }
}

