/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.runtime.CompositeData;
import org.onosproject.yang.runtime.CompositeStream;
import org.onosproject.yang.runtime.DefaultYangSerializerContext;
import org.onosproject.yang.runtime.RuntimeContext;
import org.onosproject.yang.runtime.YangRuntimeException;
import org.onosproject.yang.runtime.YangRuntimeService;
import org.onosproject.yang.runtime.YangSerializer;
import org.onosproject.yang.runtime.YangSerializerRegistry;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.DefaultYangSerializerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultYangRuntimeHandler
implements YangRuntimeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultYangModelRegistry.class);
    private static final String DF = "Data format ";
    private static final String NR = " is not registered.";
    private YangSerializerRegistry registry;
    private SchemaContext rootContext;

    public DefaultYangRuntimeHandler(YangSerializerRegistry r, SchemaContext c) {
        this.registry = r;
        this.rootContext = c;
    }

    @Override
    public CompositeData decode(CompositeStream external, RuntimeContext c) {
        YangSerializer ys = this.getRegisteredSerializer(c.getDataFormat());
        DefaultYangSerializerContext sc = new DefaultYangSerializerContext(this.rootContext, c.getProtocolAnnotations());
        return ys.decode(external, sc);
    }

    @Override
    public CompositeStream encode(CompositeData internal, RuntimeContext c) {
        YangSerializer ys = this.getRegisteredSerializer(c.getDataFormat());
        DefaultYangSerializerContext sc = new DefaultYangSerializerContext(this.rootContext, c.getProtocolAnnotations());
        return ys.encode(internal, sc);
    }

    private YangSerializer getRegisteredSerializer(String df) {
        YangSerializer s = ((DefaultYangSerializerRegistry)this.registry).getSerializer(df);
        if (s == null) {
            log.info("Data format  {}  is not registered.", (Object)df);
            throw new YangRuntimeException(DF + df + NR);
        }
        return s;
    }
}

