/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.util.List;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangChoice;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.DefaultResourceData;
import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.LeafModelObject;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.ResourceData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DataTreeBuilderHelper;
import org.onosproject.yang.runtime.impl.DataTreeNodeInfo;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.ModIdToRscIdConverter;
import org.onosproject.yang.runtime.impl.ModelConverterUtil;
import org.onosproject.yang.runtime.impl.ModelConvertorException;

class DefaultDataTreeBuilder {
    private final DefaultYangModelRegistry reg;

    DefaultDataTreeBuilder(DefaultYangModelRegistry registry) {
        this.reg = registry;
    }

    ResourceData getResourceData(ModelObjectData modelData) {
        List modelObjects = modelData.modelObjects();
        ModelObjectId id = modelData.identifier();
        DefaultResourceData.Builder rscData = DefaultResourceData.builder();
        ModIdToRscIdConverter converter = new ModIdToRscIdConverter(this.reg);
        rscData.resourceId(converter.fetchResourceId(id));
        YangSchemaNode lastIndexNode = converter.getLastIndexNode();
        if (!DataModelUtils.nonEmpty(modelObjects)) {
            return rscData.build();
        }
        if (converter.isMoIdWithLeaf() && DataModelUtils.nonEmpty(modelObjects)) {
            throw new ModelConvertorException("invalid module object data when model object identifier contains leaf node, no object should be added to model object list." + modelData);
        }
        if (id == null || !DataModelUtils.nonEmpty(id.atomicPaths())) {
            lastIndexNode = this.fetchModNode((ModelObject)modelObjects.get(0), converter);
        }
        DataTreeBuilderHelper helper = new DataTreeBuilderHelper(this.reg);
        for (ModelObject modObj : modelObjects) {
            if (modObj instanceof LeafModelObject) {
                this.processLeafObj(lastIndexNode, rscData, (LeafModelObject)modObj);
                continue;
            }
            YangSchemaNode curNode = converter.isInputOrOutput() ? this.handleRpcChild(modObj, (YangNode)lastIndexNode, rscData) : this.fetchCurNode(modObj, (YangNode)lastIndexNode);
            if (curNode != null) {
                this.processDataNodeConversion((YangNode)curNode, helper, rscData, modObj);
                continue;
            }
            throw new ModelConvertorException("failed to convert model object in data node" + modObj);
        }
        return rscData.build();
    }

    private void processDataNodeConversion(YangNode curNode, DataTreeBuilderHelper helper, DefaultResourceData.Builder rscData, Object curObj) {
        if (curNode == null) {
            return;
        }
        DataTreeNodeInfo info = new DataTreeNodeInfo();
        this.setObjInParent(curNode, curObj, info);
        info.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        switch (curNode.getYangSchemaNodeType()) {
            case YANG_SINGLE_INSTANCE_NODE: 
            case YANG_MULTI_INSTANCE_NODE: {
                this.processNodeObj(helper, curObj, (ResourceData.Builder)rscData, curNode);
                break;
            }
            case YANG_AUGMENT_NODE: {
                this.processModelObjects(helper, curNode, rscData, curObj);
                break;
            }
            case YANG_CHOICE_NODE: {
                this.handleChoiceNode(curNode, info, helper, rscData);
                break;
            }
            case YANG_NON_DATA_NODE: {
                if (!(curNode instanceof YangCase)) break;
                this.handleCaseNode(curNode, info, helper, rscData);
                break;
            }
            default: {
                throw new ModelConvertorException("Non processable schema node has arrived for adding it in data tree");
            }
        }
    }

    private YangSchemaNode handleRpcChild(Object obj, YangNode parent, DefaultResourceData.Builder rscData) {
        if (obj != null && parent != null) {
            YangNode child;
            String name = obj.getClass().getName();
            for (child = parent.getChild(); child != null && !(child instanceof YangRpc); child = child.getNextSibling()) {
            }
            if (child != null) {
                ResourceId id = ResourceId.builder().addBranchPointSchema("/", null).addBranchPointSchema(child.getName(), child.getNameSpace().getModuleNamespace()).build();
                rscData.resourceId(id);
                child = child.getChild();
                return this.getNode(child, name);
            }
        }
        return this.fetchCurNode(obj, parent);
    }

    private YangSchemaNode fetchCurNode(Object obj, YangNode parent) {
        if (obj != null && parent != null) {
            String name = obj.getClass().getName();
            YangNode child = parent.getChild();
            while (child != null) {
                if (child.getYangSchemaNodeType() == YangSchemaNodeType.YANG_NON_DATA_NODE) {
                    child = child.getNextSibling();
                    continue;
                }
                YangSchemaNode output = child instanceof YangChoice ? this.findFromChoiceNode(name, parent) : (child instanceof YangCase ? this.findFromCaseNode(name, parent) : this.getNode(child, name));
                if (output != null) {
                    return output;
                }
                child = child.getNextSibling();
            }
            return this.findIfAugmentable(name, parent);
        }
        return null;
    }

    private YangSchemaNode findIfAugmentable(String name, YangNode parent) {
        List<YangAugment> augments = ((YangAugmentableNode)((Object)parent)).getAugmentedInfoList();
        if (DataModelUtils.nonEmpty(augments)) {
            YangSchemaNode output;
            for (YangAugment augment : augments) {
                output = this.getNode(augment, name);
                if (output == null) continue;
                return output;
            }
            for (YangAugment augment : augments) {
                YangNode child = augment.getChild();
                output = this.getNode(child, name);
                if (output == null) continue;
                return output;
            }
        }
        return null;
    }

    private YangSchemaNode findFromChoiceNode(String qName, YangSchemaNode parent) {
        for (YangNode child = ((YangNode)parent).getChild(); child != null; child = child.getNextSibling()) {
            YangSchemaNode output;
            if (!(child instanceof YangChoice) || (output = this.findFromCaseNode(qName, child)) == null) continue;
            return output;
        }
        return null;
    }

    private YangSchemaNode findFromCaseNode(String qName, YangSchemaNode parent) {
        for (YangNode caseNode = ((YangNode)parent).getChild(); caseNode != null; caseNode = caseNode.getNextSibling()) {
            String javaName = caseNode.getJavaPackage() + "." + "Default" + RuntimeHelper.getCapitalCase(YangIoUtils.getCamelCase(caseNode.getName(), null));
            if (!javaName.equals(qName)) continue;
            return caseNode;
        }
        return this.findIfAugmentable(qName, (YangNode)parent);
    }

    private YangSchemaNode getNode(YangNode child, String pkg) {
        while (child != null) {
            String javaName = child instanceof YangAugment ? child.getJavaPackage() + "." + "Default" + YangJavaModelUtils.getAugmentClassName((YangAugment)child, new YangPluginConfig()) : (child instanceof YangInput || child instanceof YangOutput ? child.getJavaPackage() + "." + "Default" + RuntimeHelper.getCapitalCase(child.getJavaClassNameOrBuiltInType()) : child.getJavaPackage() + "." + "Default" + RuntimeHelper.getCapitalCase(YangIoUtils.getCamelCase(child.getName(), null)));
            if (javaName.equals(pkg)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private YangSchemaNode fetchModNode(ModelObject object, ModIdToRscIdConverter converter) {
        if (object instanceof LeafModelObject) {
            LeafModelObject obj = (LeafModelObject)object;
            return converter.fetchModNodeFromLeaf(obj.leafIdentifier().getClass().getName());
        }
        return converter.fetchModuleNode(object.getClass().getName());
    }

    private void processLeafObj(YangSchemaNode rootNode, DefaultResourceData.Builder rscData, LeafModelObject rootObj) {
        YangLeavesHolder holder = (YangLeavesHolder)((Object)rootNode);
        if (rootObj.leafIdentifier() != null) {
            List<YangLeafList> leafLists;
            String name = rootObj.leafIdentifier().toString().toLowerCase();
            List values = rootObj.values();
            List<YangLeaf> leaves = holder.getListOfLeaf();
            if (DataModelUtils.nonEmpty(leaves)) {
                for (YangLeaf leaf : leaves) {
                    if (!name.equals(leaf.getJavaAttributeName().toLowerCase())) continue;
                    LeafNode node = ((LeafNode.Builder)LeafNode.builder((String)leaf.getName(), (String)leaf.getNameSpace().getModuleNamespace()).value(values.get(0)).type(DataNode.Type.SINGLE_INSTANCE_LEAF_VALUE_NODE)).build();
                    rscData.addDataNode((DataNode)node);
                    break;
                }
            }
            if (DataModelUtils.nonEmpty(leafLists = holder.getListOfLeafList())) {
                for (YangLeafList leafList : leafLists) {
                    if (!name.equals(leafList.getJavaAttributeName().toLowerCase())) continue;
                    for (Object o : values) {
                        LeafNode node = ((LeafNode.Builder)LeafNode.builder((String)leafList.getName(), (String)leafList.getNameSpace().getModuleNamespace()).value(o).type(DataNode.Type.MULTI_INSTANCE_LEAF_VALUE_NODE)).build();
                        rscData.addDataNode((DataNode)node);
                    }
                }
            }
        }
    }

    private void processNodeObj(DataTreeBuilderHelper helper, Object modObj, ResourceData.Builder rscData, YangSchemaNode curRoot) {
        InnerNode.Builder builder = InnerNode.builder((String)curRoot.getName(), (String)curRoot.getNameSpace().getModuleNamespace());
        if (curRoot instanceof YangList) {
            builder.type(DataNode.Type.MULTI_INSTANCE_NODE);
        } else {
            builder.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        }
        builder = helper.getDataTree(curRoot, (DataNode.Builder)builder, modObj);
        if (builder != null) {
            rscData.addDataNode(builder.build());
        }
    }

    private void processModelObjects(DataTreeBuilderHelper modYo, YangSchemaNode lastIndexNode, DefaultResourceData.Builder rscData, Object yangObj) {
        this.processRootLeafInfo(modYo, lastIndexNode, rscData, yangObj);
        this.processRootLevelListNode(modYo, lastIndexNode, rscData, yangObj);
        this.processRootLevelSingleInNode(modYo, lastIndexNode, rscData, yangObj);
    }

    private void processRootLeafInfo(DataTreeBuilderHelper modYo, YangSchemaNode rootNode, DefaultResourceData.Builder rscData, Object rootObj) {
        List<YangLeafList> leafLists;
        List<YangLeaf> leaves;
        YangLeavesHolder holder = (YangLeavesHolder)((Object)rootNode);
        if (rootNode instanceof YangCase && ((YangCase)rootNode).getParent().getParent() instanceof RpcNotificationContainer) {
            modYo.setExtBuilder(null);
        }
        if (DataModelUtils.nonEmpty(leaves = holder.getListOfLeaf())) {
            for (YangLeaf leaf : leaves) {
                try {
                    DataNode.Builder builder = modYo.addLeafWithValue(rootNode, leaf, rootObj, ModelConverterUtil.getAttributeOfObject(rootObj, leaf.getJavaAttributeName()));
                    this.addDataNode(builder, rscData);
                }
                catch (NoSuchMethodException e) {
                    throw new ModelConvertorException("failed to create data node for leaf " + leaf.getName());
                }
            }
        }
        if (DataModelUtils.nonEmpty(leafLists = holder.getListOfLeafList())) {
            for (YangLeafList leafList : leafLists) {
                try {
                    List<DataNode.Builder> nodes;
                    List obj = (List)ModelConverterUtil.getAttributeOfObject(rootObj, ModelConverterUtil.getJavaName(leafList));
                    if (obj == null || (nodes = modYo.addLeafListValue(rootNode, rootObj, leafList, obj)) == null) continue;
                    for (DataNode.Builder node : nodes) {
                        rscData.addDataNode(node.build());
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new ModelConvertorException(e);
                }
            }
        }
    }

    private void processRootLevelListNode(DataTreeBuilderHelper helper, YangSchemaNode curRootNode, DefaultResourceData.Builder rscData, Object curRootObj) {
        DataTreeNodeInfo parentInfo = new DataTreeNodeInfo();
        this.setObjInParent(curRootNode, curRootObj, parentInfo);
        parentInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        for (YangNode curNode = ((YangNode)curRootNode).getChild(); curNode != null && (curNode = this.verifyAndGetList(curNode)) != null; curNode = curNode.getNextSibling()) {
            List childObjList = (List)helper.getChildObject(curNode, parentInfo);
            if (!DataModelUtils.nonEmpty(childObjList)) continue;
            for (Object childObj : childObjList) {
                DataNode.Builder output;
                DataNode.Builder builder = InnerNode.builder((String)curNode.getName(), (String)curNode.getNameSpace().getModuleNamespace()).type(DataNode.Type.MULTI_INSTANCE_NODE);
                if (childObj == null || (output = helper.getDataTree(curNode, builder, childObj)) == null) continue;
                rscData.addDataNode(output.build());
            }
        }
    }

    private void setObjInParent(YangSchemaNode rootNode, Object rootObj, DataTreeNodeInfo parentInfo) {
        if (rootNode instanceof YangCase) {
            parentInfo.setCaseObject(rootObj);
        }
        if (rootNode instanceof YangAugment) {
            parentInfo.setAugmentObject(rootObj);
            parentInfo.setYangObject(rootObj);
        } else {
            parentInfo.setYangObject(rootObj);
        }
    }

    private void processRootLevelSingleInNode(DataTreeBuilderHelper helper, YangSchemaNode rootNode, DefaultResourceData.Builder rscData, Object rootObj) {
        List<YangAugment> augments;
        DataTreeNodeInfo parentInfo = new DataTreeNodeInfo();
        parentInfo.type(DataNode.Type.SINGLE_INSTANCE_NODE);
        this.setObjInParent(rootNode, rootObj, parentInfo);
        Object childObj = null;
        for (YangNode curNode = ((YangNode)rootNode).getChild(); curNode != null && (curNode = this.verifyAndDoNotGetList(curNode, helper, parentInfo, rscData)) != null; curNode = curNode.getNextSibling()) {
            DataNode.Builder builder;
            DataNode.Builder output;
            if (curNode.getYangSchemaNodeType() != YangSchemaNodeType.YANG_NON_DATA_NODE) {
                childObj = helper.getChildObject(curNode, parentInfo);
            }
            if (childObj == null || (output = helper.getDataTree(curNode, builder = InnerNode.builder((String)curNode.getName(), (String)curNode.getNameSpace().getModuleNamespace()).type(DataNode.Type.SINGLE_INSTANCE_NODE), childObj)) == null) continue;
            rscData.addDataNode(output.build());
        }
        if (rootNode instanceof YangAugmentableNode && DataModelUtils.nonEmpty(augments = ((YangAugmentableNode)((Object)rootNode)).getAugmentedInfoList())) {
            for (YangAugment augment : augments) {
                childObj = helper.processAugmentNode(augment, parentInfo);
                if (childObj == null) continue;
                this.processModelObjects(helper, augment, rscData, childObj);
            }
        }
    }

    private YangNode verifyAndGetList(YangNode curNode) {
        if (curNode == null) {
            return null;
        }
        if (!(curNode instanceof YangList)) {
            curNode = curNode.getNextSibling();
            curNode = this.verifyAndGetList(curNode);
        }
        return curNode;
    }

    private YangNode verifyAndDoNotGetList(YangNode curNode, DataTreeBuilderHelper helper, DataTreeNodeInfo info, DefaultResourceData.Builder rscData) {
        if (curNode == null) {
            return null;
        }
        switch (curNode.getYangSchemaNodeType()) {
            case YANG_SINGLE_INSTANCE_NODE: {
                return curNode;
            }
            case YANG_MULTI_INSTANCE_NODE: 
            case YANG_AUGMENT_NODE: {
                break;
            }
            case YANG_CHOICE_NODE: {
                this.handleChoiceNode(curNode, info, helper, rscData);
                break;
            }
            case YANG_NON_DATA_NODE: {
                if (!(curNode instanceof YangCase)) break;
                this.handleCaseNode(curNode, info, helper, rscData);
                break;
            }
            default: {
                throw new ModelConvertorException("Non processable schema node has arrived for adding it in data tree");
            }
        }
        return this.processReCheckSibling(curNode, helper, info, rscData);
    }

    private YangNode processReCheckSibling(YangNode curNode, DataTreeBuilderHelper helper, DataTreeNodeInfo info, DefaultResourceData.Builder rscData) {
        curNode = curNode.getNextSibling();
        curNode = this.verifyAndDoNotGetList(curNode, helper, info, rscData);
        return curNode;
    }

    private void handleChoiceNode(YangNode curNode, DataTreeNodeInfo info, DataTreeBuilderHelper helper, DefaultResourceData.Builder rscData) {
        Object childObj = helper.processChoiceNode(curNode, info);
        YangNode tempNode = curNode;
        if (childObj != null) {
            for (curNode = curNode.getChild(); curNode != null; curNode = curNode.getNextSibling()) {
                this.processCaseNode(curNode, info, helper, rscData);
            }
            List<YangAugment> augments = ((YangChoice)tempNode).getAugmentedInfoList();
            if (DataModelUtils.nonEmpty(augments)) {
                for (YangAugment augment : augments) {
                    for (YangNode caseNode = augment.getChild(); caseNode != null && caseNode instanceof YangCase; caseNode = caseNode.getNextSibling()) {
                        this.processCaseNode(caseNode, info, helper, rscData);
                    }
                }
            }
        }
    }

    private void processCaseNode(YangNode curNode, DataTreeNodeInfo info, DataTreeBuilderHelper helper, DefaultResourceData.Builder rscData) {
        Object childObj = helper.processCaseNode(curNode, info);
        if (childObj != null) {
            this.processModelObjects(helper, curNode, rscData, childObj);
        }
    }

    private void handleCaseNode(YangNode curNode, DataTreeNodeInfo info, DataTreeBuilderHelper yo, DefaultResourceData.Builder rscData) {
        Object obj = info.getYangObject();
        if (obj != null) {
            this.processModelObjects(yo, curNode, rscData, obj);
        }
    }

    private void addDataNode(DataNode.Builder node, DefaultResourceData.Builder builder) {
        if (node != null) {
            builder.addDataNode(node.build());
        }
    }
}

