/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.helperutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.model.DefaultYangModel;
import org.onosproject.yang.model.DefaultYangModuleId;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.helperutils.YangModuleExtendedInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangApacheUtils {
    private static final String SLASH = File.separator;
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String YANG_META_DATA = "YangMetaData.ser";
    private static final String YANG_RESOURCES = "yang/resources";
    private static final String SYSTEM = SLASH + "system" + SLASH;
    private static final String MAVEN = "mvn:";
    private static final String JAR = ".jar";
    private static final String USER_DIRECTORY = "user.dir";
    private static final Logger log = LoggerFactory.getLogger(YangApacheUtils.class);

    private YangApacheUtils() {
    }

    public static YangModel getYangModel(Class<?> modClass) {
        BundleContext context = FrameworkUtil.getBundle(modClass).getBundleContext();
        if (context != null) {
            Bundle bundle = context.getBundle();
            String jarPath = YangApacheUtils.getJarPathFromBundleLocation(bundle.getLocation(), context.getProperty(USER_DIRECTORY));
            String metaPath = jarPath + SLASH + YANG_RESOURCES + SLASH + YANG_META_DATA;
            List<YangNode> curNodes = YangApacheUtils.processJarParsingOperations(jarPath);
            if (curNodes != null && !curNodes.isEmpty()) {
                return YangApacheUtils.processYangModel(metaPath, curNodes);
            }
        }
        return null;
    }

    public static YangModel processYangModel(String path, List<YangNode> curNodes) {
        DefaultYangModel.Builder b = DefaultYangModel.builder();
        for (YangNode node : curNodes) {
            YangModuleId id = YangApacheUtils.processModuleId(node);
            YangModuleExtendedInfo module = new YangModuleExtendedInfo(id, Paths.get(node.getFileName(), new String[0]), Paths.get(path, new String[0]));
            module.setSchema(node);
            b.addModule(id, (YangModule)module);
        }
        return b.build();
    }

    public static YangModuleId processModuleId(YangNode module) {
        String rev = DataModelUtils.getDateInStringFormat(module);
        return new DefaultYangModuleId(module.getName(), rev);
    }

    private static String getJarPathFromBundleLocation(String mvnLocationPath, String currentDirectory) {
        String[] split;
        String[] strArray;
        StringBuilder builder = new StringBuilder();
        builder.append(currentDirectory).append(SYSTEM);
        StringBuilder ver = new StringBuilder();
        if (mvnLocationPath.contains(MAVEN) && (strArray = mvnLocationPath.split(MAVEN))[1].contains(File.separator) && (split = strArray[1].split(File.separator))[0].contains(PERIOD)) {
            String[] groupId;
            for (String s : groupId = split[0].split(Pattern.quote(PERIOD))) {
                builder.append(s).append(SLASH);
            }
            for (int i = 1; i < split.length; ++i) {
                builder.append(split[i]).append(SLASH);
                ver.append(split[i]).append(HYPHEN);
            }
            builder.append((CharSequence)ver);
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        return null;
    }

    private static List<YangNode> processJarParsingOperations(String path) {
        String jar = path + JAR;
        try {
            File file = new File(jar);
            if (file.exists()) {
                return DataModelUtils.parseJarFile(path + JAR, path);
            }
        }
        catch (IOException e) {
            log.error(" failed to parse the jar file in path {} : {} ", (Object)path, (Object)e.getMessage());
        }
        return null;
    }
}

