/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.runtime.AnnotatedNodeInfo;
import org.onosproject.yang.runtime.Annotation;

public class DefaultAnnotatedNodeInfo
implements AnnotatedNodeInfo {
    private ResourceId resourceId;
    private List<Annotation> annotations;

    protected DefaultAnnotatedNodeInfo(Builder b) {
        this.resourceId = b.resourceId;
        this.annotations = b.annotations;
    }

    @Override
    public ResourceId resourceId() {
        return this.resourceId;
    }

    @Override
    public List<Annotation> annotations() {
        return this.annotations;
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.annotations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAnnotatedNodeInfo) {
            DefaultAnnotatedNodeInfo that = (DefaultAnnotatedNodeInfo)obj;
            return Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.annotations, that.annotations);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("resourceId", (Object)this.resourceId).add("annotations", this.annotations).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements AnnotatedNodeInfo.Builder {
        private ResourceId resourceId;
        private List<Annotation> annotations = new LinkedList<Annotation>();

        @Override
        public Builder resourceId(ResourceId id) {
            this.resourceId = id;
            return this;
        }

        @Override
        public Builder addAnnotation(Annotation a) {
            this.annotations.add(a);
            return this;
        }

        @Override
        public AnnotatedNodeInfo build() {
            return new DefaultAnnotatedNodeInfo(this);
        }
    }
}

