/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.translator.tojava;

import java.io.IOException;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.translator.exception.InvalidNodeForTranslatorException;
import org.onosproject.yang.compiler.translator.exception.TranslatorException;
import org.onosproject.yang.compiler.translator.tojava.JavaCodeGenerator;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yang.compiler.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yang.compiler.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yang.compiler.translator.tojava.YangJavaModelUtils;
import org.onosproject.yang.compiler.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yang.compiler.utils.io.YangPluginConfig;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;

public final class JavaCodeGeneratorUtil {
    private JavaCodeGeneratorUtil() {
    }

    public static void translate(YangNode rootNode, YangPluginConfig yangPlugin, boolean codeGen) throws TranslatorException, IOException {
        YangNode codeGenNode = rootNode;
        TraversalType curTraversal = TraversalType.ROOT;
        while (codeGenNode != null) {
            if (curTraversal != TraversalType.PARENT) {
                if (!(codeGenNode instanceof JavaCodeGenerator)) {
                    throw new TranslatorException("Unsupported node to generate code " + codeGenNode.getName() + " in " + codeGenNode.getLineNumber() + " at " + codeGenNode.getCharPosition() + " in " + codeGenNode.getFileName());
                }
                try {
                    if (codeGen) {
                        JavaCodeGeneratorUtil.generateCodeEntry(codeGenNode, yangPlugin, rootNode);
                    } else if (!(codeGenNode instanceof YangUses)) {
                        YangJavaModelUtils.updateJavaInfo(codeGenNode, yangPlugin);
                        if (codeGenNode instanceof YangNotification) {
                            String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(codeGenNode.getName().toUpperCase());
                            ((RpcNotificationContainer)((Object)codeGenNode.getParent())).addToNotificationEnumMap(enumName, codeGenNode);
                        }
                    } else {
                        if (codeGenNode.getNextSibling() != null) {
                            curTraversal = TraversalType.SIBLING;
                            codeGenNode = codeGenNode.getNextSibling();
                            continue;
                        }
                        curTraversal = TraversalType.PARENT;
                        codeGenNode = codeGenNode.getParent();
                        continue;
                    }
                    codeGenNode.setNameSpaceAndAddToParentSchemaMap();
                    if (codeGenNode instanceof YangLeavesHolder || codeGenNode instanceof SchemaDataNode) {
                        codeGenNode.setParentContext();
                    }
                }
                catch (InvalidNodeForTranslatorException e) {
                    if (codeGenNode.getNextSibling() != null) {
                        curTraversal = TraversalType.SIBLING;
                        codeGenNode = codeGenNode.getNextSibling();
                        continue;
                    }
                    curTraversal = TraversalType.PARENT;
                    codeGenNode = codeGenNode.getParent();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin, rootNode);
                    throw new TranslatorException(e.getMessage());
                }
            }
            if (curTraversal != TraversalType.PARENT && codeGenNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                codeGenNode = codeGenNode.getChild();
                continue;
            }
            if (codeGenNode.getNextSibling() != null) {
                try {
                    if (codeGen) {
                        JavaCodeGeneratorUtil.generateCodeExit(codeGenNode, yangPlugin, rootNode);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin, rootNode);
                    throw new TranslatorException(e.getMessage());
                }
                curTraversal = TraversalType.SIBLING;
                codeGenNode = codeGenNode.getNextSibling();
                continue;
            }
            try {
                if (codeGen) {
                    JavaCodeGeneratorUtil.generateCodeExit(codeGenNode, yangPlugin, rootNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin, rootNode);
                throw new TranslatorException(e.getMessage());
            }
            curTraversal = TraversalType.PARENT;
            codeGenNode = codeGenNode.getParent();
        }
    }

    public static void generateJavaCode(YangNode rootNode, YangPluginConfig yangPlugin) throws TranslatorException, IOException {
        JavaCodeGeneratorUtil.translate(rootNode, yangPlugin, true);
    }

    private static void generateCodeEntry(YangNode codeGenNode, YangPluginConfig yangPlugin, YangNode rootNode) throws TranslatorException, IOException {
        if (!(codeGenNode instanceof JavaCodeGenerator)) {
            JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin, rootNode);
            throw new TranslatorException("Generated data model node cannot be translated to target language code for " + codeGenNode.getName() + " in " + codeGenNode.getLineNumber() + " at " + codeGenNode.getCharPosition() + " in " + codeGenNode.getFileName());
        }
        ((JavaCodeGenerator)((Object)codeGenNode)).generateCodeEntry(yangPlugin);
    }

    private static void generateCodeExit(YangNode codeGenNode, YangPluginConfig pluginConfig, YangNode rootNode) throws TranslatorException, IOException {
        if (!(codeGenNode instanceof JavaCodeGenerator)) {
            JavaCodeGeneratorUtil.close(codeGenNode, pluginConfig, rootNode);
            throw new TranslatorException("Generated data model node cannot be translated to target language code for " + codeGenNode.getName() + " in " + codeGenNode.getLineNumber() + " at " + codeGenNode.getCharPosition() + " in " + codeGenNode.getFileName());
        }
        ((JavaCodeGenerator)((Object)codeGenNode)).generateCodeExit();
    }

    private static void freeRestResources(YangNode freedNode) {
        if (freedNode != null) {
            YangNode tempNode = freedNode;
            TraversalType curTraversal = TraversalType.ROOT;
            while (freedNode != tempNode.getParent()) {
                if (curTraversal != TraversalType.PARENT && freedNode.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    freedNode = freedNode.getChild();
                    continue;
                }
                if (freedNode.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBLING;
                    if (freedNode != tempNode) {
                        JavaCodeGeneratorUtil.free(freedNode);
                    }
                    freedNode = freedNode.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                if (freedNode != tempNode) {
                    JavaCodeGeneratorUtil.free(freedNode);
                }
                freedNode = freedNode.getParent();
            }
        }
    }

    private static void free(YangNode node) {
        YangNode parent = node.getParent();
        parent.setChild(null);
        if (node.getNextSibling() != null) {
            parent.setChild(node.getNextSibling());
        } else if (node.getPreviousSibling() != null) {
            parent.setChild(node.getPreviousSibling());
        }
        node = null;
    }

    public static void translatorErrorHandler(YangNode rootNode, YangPluginConfig yangPluginConfig) throws IOException {
        if (rootNode != null) {
            YangNode tempNode = rootNode;
            YangNode curNode = tempNode.getChild();
            TraversalType curTraversal = TraversalType.ROOT;
            while (tempNode != null) {
                if (curTraversal != TraversalType.PARENT) {
                    JavaCodeGeneratorUtil.close(tempNode, yangPluginConfig, rootNode);
                }
                if (curTraversal != TraversalType.PARENT && tempNode.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    tempNode = tempNode.getChild();
                    continue;
                }
                if (tempNode.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBLING;
                    tempNode = tempNode.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                tempNode = tempNode.getParent();
            }
            JavaCodeGeneratorUtil.freeRestResources(curNode);
        }
    }

    private static void close(YangNode node, YangPluginConfig yangPlugin, YangNode rootNode) throws IOException {
        if (node instanceof JavaCodeGenerator && ((TempJavaCodeFragmentFilesContainer)((Object)node)).getTempJavaCodeFragmentFiles() != null) {
            ((TempJavaCodeFragmentFilesContainer)((Object)node)).getTempJavaCodeFragmentFiles().freeTemporaryResources(true);
        }
        if (rootNode != null) {
            JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)((Object)rootNode)).getJavaFileInfo();
            if (javaFileInfo.getPackage() != null) {
                YangIoUtils.searchAndDeleteTempDir(javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath());
            } else {
                YangIoUtils.searchAndDeleteTempDir(yangPlugin.getCodeGenDir());
            }
        }
    }

    public static YangNode searchYangNode(YangNode parentNode, YangNodeType nodeType, String nodeName) {
        YangNode child = parentNode.getChild();
        TraversalType curTraversal = TraversalType.ROOT;
        if (child == null) {
            throw new IllegalArgumentException("Given parent node does not contain any child nodes");
        }
        while (child != null) {
            if (curTraversal != TraversalType.PARENT && (child instanceof YangInput || child instanceof YangOutput ? child.getNodeType().equals((Object)nodeType) : child.getName().equals(nodeName) && child.getNodeType().equals((Object)nodeType))) {
                return child;
            }
            if (curTraversal != TraversalType.PARENT && child.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                child = child.getChild();
                continue;
            }
            if (child.getNextSibling() != null) {
                curTraversal = TraversalType.SIBLING;
                child = child.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            child = child.getParent();
        }
        return null;
    }
}

