/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class SubModuleListener {
    private SubModuleListener() {
    }

    public static void processSubModuleEntry(TreeWalkListener listener, GeneratedYangParser.SubModuleStatementContext ctx) {
        ListenerValidation.checkStackIsEmpty(listener, ListenerErrorType.INVALID_HOLDER, YangConstructType.SUB_MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.SUB_MODULE_DATA, ctx);
        YangSubModule yangSubModule = YangDataModelFactory.getYangSubModuleNode(GeneratedLanguage.JAVA_GENERATION);
        yangSubModule.setName(identifier);
        yangSubModule.setLineNumber(ctx.getStart().getLine());
        yangSubModule.setCharPosition(ctx.getStart().getCharPositionInLine());
        yangSubModule.setFileName(listener.getFileName());
        if (ctx.submoduleBody().submoduleHeaderStatement().yangVersionStatement() == null) {
            yangSubModule.setVersion((byte)1);
        }
        listener.getParsedDataStack().push(yangSubModule);
    }

    public static void processSubModuleExit(TreeWalkListener listener, GeneratedYangParser.SubModuleStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.SUB_MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangSubModule)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.SUB_MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        YangSubModule subModule = (YangSubModule)tmpNode;
        if (subModule.getUnresolvedResolutionList(ResolvableType.YANG_COMPILER_ANNOTATION) != null && subModule.getUnresolvedResolutionList(ResolvableType.YANG_COMPILER_ANNOTATION).size() != 0 && subModule.getChild() != null) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CHILD, YangConstructType.MODULE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        try {
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_IF_FEATURE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_USES);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_LEAFREF);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_BASE);
            ((YangReferenceResolver)((Object)listener.getParsedDataStack().peek())).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
        }
        catch (DataModelException e) {
            LinkerException linkerException = new LinkerException(e.getMessage());
            linkerException.setLine(e.getLineNumber());
            linkerException.setCharPosition(e.getCharPositionInLine());
            linkerException.setFileName(listener.getFileName());
            throw linkerException;
        }
        try {
            DataModelUtils.validateMultipleDeviationStatement(subModule);
        }
        catch (DataModelException e) {
            throw new ParserException(e.getMessage());
        }
    }
}

