/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangDecimal64;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.RestrictionResolver;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypeUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class RangeRestrictionListener {
    private static final String E_INVALID_TYPE = "YANG file error: Range restriction can't be applied to a given type";

    private RangeRestrictionListener() {
    }

    public static void processRangeRestrictionEntry(TreeWalkListener lis, GeneratedYangParser.RangeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(lis, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = lis.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        RangeRestrictionListener.setRangeRestriction(lis, type, ctx);
    }

    private static void setRangeRestriction(TreeWalkListener lis, YangType type, GeneratedYangParser.RangeStatementContext ctx) {
        String txt = ctx.range().getText();
        int line = ctx.getStart().getLine();
        int pos = ctx.getStart().getCharPositionInLine();
        YangDataTypes dataType = type.getDataType();
        YangRangeRestriction ranRes = new YangRangeRestriction(txt);
        ranRes.setFileName(lis.getFileName());
        ranRes.setCharPosition(pos);
        ranRes.setLineNumber(line);
        lis.getParsedDataStack().push(ranRes);
        if (dataType == YangDataTypes.DERIVED) {
            YangDerivedInfo info = (YangDerivedInfo)type.getDataTypeExtendedInfo();
            info.setRangeRes(ranRes);
            info.setFileName(lis.getFileName());
            info.setCharPosition(pos);
            info.setLineNumber(line);
            return;
        }
        if (!YangDataTypeUtils.isOfRangeRestrictedType(dataType) && dataType != YangDataTypes.DECIMAL64) {
            ParserException exc = new ParserException(E_INVALID_TYPE);
            exc.setLine(line);
            exc.setCharPosition(pos);
            throw exc;
        }
        try {
            if (dataType == YangDataTypes.DECIMAL64) {
                YangDecimal64 deci64 = (YangDecimal64)type.getDataTypeExtendedInfo();
                ranRes = RestrictionResolver.processRangeRestriction(deci64.getDefaultRangeRestriction(), line, pos, true, ranRes, dataType, lis.getFileName());
            } else {
                ranRes = RestrictionResolver.processRangeRestriction(null, line, pos, false, ranRes, dataType, lis.getFileName());
            }
        }
        catch (DataModelException e) {
            ParserException exc = new ParserException(e.getMessage());
            exc.setCharPosition(e.getCharPositionInLine());
            exc.setLine(e.getLineNumber());
            throw exc;
        }
        if (ranRes != null) {
            if (dataType == YangDataTypes.DECIMAL64) {
                ((YangDecimal64)type.getDataTypeExtendedInfo()).setRangeRestrictedExtendedInfo(ranRes);
            } else {
                type.setDataTypeExtendedInfo(ranRes);
            }
        }
    }

    public static void processRangeRestrictionExit(TreeWalkListener lis, GeneratedYangParser.RangeStatementContext ctx) {
        String txt = ctx.range().getText();
        ListenerValidation.checkStackIsNotEmpty(lis, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, txt, ListenerErrorLocation.EXIT);
        Parsable tmpData = lis.getParsedDataStack().peek();
        if (!(tmpData instanceof YangRangeRestriction)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.RANGE_DATA, txt, ListenerErrorLocation.EXIT));
        }
        lis.getParsedDataStack().pop();
    }
}

