/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangPatternRestriction;
import org.onosproject.yang.compiler.datamodel.YangStringRestriction;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class PatternRestrictionListener {
    private static final String E_INVALID_TYPE = "YANG file error : Pattern can only be used to restrict the built-in type string or types derived from string.";

    private PatternRestrictionListener() {
    }

    public static void processPatternRestrictionEntry(TreeWalkListener lis, GeneratedYangParser.PatternStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(lis, ListenerErrorType.MISSING_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = lis.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.PATTERN_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        PatternRestrictionListener.setPatternRestriction(lis, type, ctx);
    }

    private static void setPatternRestriction(TreeWalkListener lis, YangType type, GeneratedYangParser.PatternStatementContext ctx) {
        if (type.getDataType() != YangDataTypes.STRING && type.getDataType() != YangDataTypes.DERIVED) {
            ParserException exc = new ParserException(E_INVALID_TYPE);
            exc.setLine(ctx.getStart().getLine());
            exc.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw exc;
        }
        String pattern = PatternRestrictionListener.getValidPattern(ctx);
        YangPatternRestriction patRes = new YangPatternRestriction(pattern);
        patRes.setFileName(lis.getFileName());
        patRes.setCharPosition(ctx.getStart().getCharPositionInLine());
        patRes.setLineNumber(ctx.getStart().getLine());
        if (type.getDataType() == YangDataTypes.STRING) {
            YangStringRestriction strRes = (YangStringRestriction)type.getDataTypeExtendedInfo();
            if (strRes == null) {
                strRes = new YangStringRestriction();
                strRes.setFileName(lis.getFileName());
                strRes.setCharPosition(ctx.getStart().getCharPositionInLine());
                strRes.setLineNumber(ctx.getStart().getLine());
                type.setDataTypeExtendedInfo(strRes);
            }
            strRes.addPaternRes(patRes);
        } else {
            YangDerivedInfo info = (YangDerivedInfo)type.getDataTypeExtendedInfo();
            info.addPatternRes(patRes);
        }
        lis.getParsedDataStack().push(patRes);
    }

    public static void processPatternRestrictionExit(TreeWalkListener listener, GeneratedYangParser.PatternStatementContext ctx) {
        String txt = ctx.string().getText();
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.PATTERN_DATA, txt, ListenerErrorLocation.EXIT);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (!(tmpData instanceof YangPatternRestriction)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.PATTERN_DATA, txt, ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static String getValidPattern(GeneratedYangParser.PatternStatementContext ctx) {
        List<TerminalNode> patternList = ctx.string().STRING();
        StringBuilder inputPat = new StringBuilder();
        for (TerminalNode pattern : patternList) {
            inputPat.append(pattern.getText());
        }
        String compile = inputPat.toString().replaceAll("['\"]", "");
        try {
            Pattern.compile(compile);
        }
        catch (PatternSyntaxException e) {
            ParserException exc = new ParserException("YANG file error : " + YangConstructType.getYangConstructType(YangConstructType.PATTERN_DATA) + " name " + ctx.string().getText() + " is not a valid regular expression");
            exc.setLine(ctx.getStart().getLine());
            exc.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw exc;
        }
        return compile;
    }
}

