/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangStringRestriction;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.RestrictionResolver;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class LengthRestrictionListener {
    private static final String E_INVALID_TYPE = "YANG file error : Length can only be used to restrict the built-in type string/binary or types derived from string/binary.";

    private LengthRestrictionListener() {
    }

    public static void processLengthRestrictionEntry(TreeWalkListener lis, GeneratedYangParser.LengthStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(lis, ListenerErrorType.MISSING_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = lis.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LENGTH_DATA, ctx.length().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        LengthRestrictionListener.setLengthRestriction(lis, type, ctx);
    }

    private static void setLengthRestriction(TreeWalkListener lis, YangType type, GeneratedYangParser.LengthStatementContext ctx) {
        int line = ctx.getStart().getLine();
        int pos = ctx.getStart().getCharPositionInLine();
        String txt = ctx.length().getText();
        YangDataTypes dataType = type.getDataType();
        YangRangeRestriction lenRes = new YangRangeRestriction(txt);
        lenRes.setFileName(lis.getFileName());
        lenRes.setCharPosition(pos);
        lenRes.setLineNumber(line);
        lis.getParsedDataStack().push(lenRes);
        if (dataType == YangDataTypes.DERIVED) {
            YangDerivedInfo info = (YangDerivedInfo)type.getDataTypeExtendedInfo();
            info.setLengthRes(lenRes);
            info.setFileName(lis.getFileName());
            info.setCharPosition(pos);
            info.setLineNumber(line);
            return;
        }
        if (dataType != YangDataTypes.STRING && dataType != YangDataTypes.BINARY) {
            ParserException exc = new ParserException(E_INVALID_TYPE);
            exc.setLine(line);
            exc.setCharPosition(pos);
            throw exc;
        }
        try {
            lenRes = RestrictionResolver.processLengthRes(null, line, pos, false, lenRes, lis.getFileName());
        }
        catch (DataModelException e) {
            ParserException exc = new ParserException(e.getMessage());
            exc.setCharPosition(e.getCharPositionInLine());
            exc.setLine(e.getLineNumber());
            throw exc;
        }
        if (dataType == YangDataTypes.STRING) {
            YangStringRestriction strRes = (YangStringRestriction)type.getDataTypeExtendedInfo();
            if (strRes == null) {
                strRes = new YangStringRestriction();
                strRes.setFileName(lis.getFileName());
                strRes.setCharPosition(ctx.getStart().getCharPositionInLine());
                strRes.setLineNumber(ctx.getStart().getLine());
                type.setDataTypeExtendedInfo(strRes);
            }
            strRes.setLengthRestriction(lenRes);
        } else {
            type.setDataTypeExtendedInfo(lenRes);
        }
    }

    public static void processLengthRestrictionExit(TreeWalkListener lis, GeneratedYangParser.LengthStatementContext ctx) {
        String txt = ctx.length().getText();
        ListenerValidation.checkStackIsNotEmpty(lis, ListenerErrorType.MISSING_HOLDER, YangConstructType.LENGTH_DATA, txt, ListenerErrorLocation.EXIT);
        Parsable tmpData = lis.getParsedDataStack().peek();
        if (!(tmpData instanceof YangRangeRestriction)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LENGTH_DATA, txt, ListenerErrorLocation.EXIT));
        }
        lis.getParsedDataStack().pop();
    }
}

