/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;
import org.onosproject.yang.compiler.translator.tojava.javamodel.YangJavaEnumerationTranslator;

public final class EnumerationListener {
    private static final String ENUMERATION_CLASS_SUFFIX = "_enum";

    private EnumerationListener() {
    }

    public static void processEnumerationEntry(TreeWalkListener listener, GeneratedYangParser.EnumSpecificationContext ctx) {
        Parsable typeData;
        YangJavaEnumerationTranslator enumerationNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY);
        if (listener.getParsedDataStack().peek() instanceof YangType) {
            enumerationNode = YangDataModelFactory.getYangEnumerationNode(GeneratedLanguage.JAVA_GENERATION);
            enumerationNode.setLineNumber(ctx.getStart().getLine());
            enumerationNode.setCharPosition(ctx.getStart().getCharPositionInLine());
            enumerationNode.setFileName(listener.getFileName());
            typeData = listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY);
            Parsable tmpData = listener.getParsedDataStack().peek();
            switch (tmpData.getYangConstructType()) {
                case LEAF_DATA: {
                    enumerationNode.setName(((YangLeaf)tmpData).getName() + ENUMERATION_CLASS_SUFFIX);
                    Parsable leaf = listener.getParsedDataStack().pop();
                    EnumerationListener.addChildToParentNode(listener, enumerationNode);
                    listener.getParsedDataStack().push(leaf);
                    break;
                }
                case LEAF_LIST_DATA: {
                    enumerationNode.setName(((YangLeafList)tmpData).getName() + ENUMERATION_CLASS_SUFFIX);
                    Parsable leafList = listener.getParsedDataStack().pop();
                    EnumerationListener.addChildToParentNode(listener, enumerationNode);
                    listener.getParsedDataStack().push(leafList);
                    break;
                }
                case UNION_DATA: {
                    YangUnion yangUnion = (YangUnion)tmpData;
                    enumerationNode.setName(yangUnion.getName() + ENUMERATION_CLASS_SUFFIX + yangUnion.getChildUnionNumber());
                    yangUnion.setChildUnionNumber(yangUnion.getChildUnionNumber() + 1);
                    EnumerationListener.addChildToParentNode(listener, enumerationNode);
                    break;
                }
                case TYPEDEF_DATA: {
                    YangTypeDef typeDef = (YangTypeDef)tmpData;
                    enumerationNode.setName(typeDef.getName() + ENUMERATION_CLASS_SUFFIX);
                    EnumerationListener.addChildToParentNode(listener, enumerationNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ((YangType)typeData).getDataTypeName(), ListenerErrorLocation.ENTRY));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push(enumerationNode);
    }

    public static void processEnumerationExit(TreeWalkListener listener, GeneratedYangParser.EnumSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT);
        Parsable tmpEnumerationNode = listener.getParsedDataStack().peek();
        if (tmpEnumerationNode instanceof YangEnumeration) {
            YangEnumeration enumerationNode = (YangEnumeration)tmpEnumerationNode;
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case TYPE_DATA: {
                    YangType typeNode = (YangType)tmpNode;
                    typeNode.setDataTypeExtendedInfo(enumerationNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT));
        }
    }

    private static void addChildToParentNode(TreeWalkListener listener, YangEnumeration enumerationNode) {
        if (!(listener.getParsedDataStack().peek() instanceof YangNode)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangNode curNode = (YangNode)((Object)listener.getParsedDataStack().peek());
        try {
            curNode.addChild(enumerationNode);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

