/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangAppDataStructure;
import org.onosproject.yang.compiler.datamodel.YangCompilerAnnotation;
import org.onosproject.yang.compiler.datamodel.YangDataStructure;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class AppDataStructureListener {
    private AppDataStructureListener() {
    }

    public static void processAppDataStructureEntry(TreeWalkListener listener, GeneratedYangParser.AppDataStructureStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.APP_DATA_STRUCTURE, "", ListenerErrorLocation.ENTRY);
        String prefix = ListenerUtil.getValidPrefix(ctx.APP_DATA_STRUCTURE().getText(), YangConstructType.APP_DATA_STRUCTURE, ctx);
        YangDataStructure dataStructure = YangDataStructure.getDataStructureType(ctx.appDataStructure().getText());
        YangAppDataStructure appDataStructure = new YangAppDataStructure();
        appDataStructure.setPrefix(prefix);
        appDataStructure.setDataStructure(dataStructure);
        appDataStructure.setLineNumber(ctx.getStart().getLine());
        appDataStructure.setCharPosition(ctx.getStart().getCharPositionInLine());
        appDataStructure.setFileName(listener.getFileName());
        Parsable curData = listener.getParsedDataStack().peek();
        if (!(curData instanceof YangCompilerAnnotation)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.APP_DATA_STRUCTURE, "", ListenerErrorLocation.ENTRY));
        }
        YangCompilerAnnotation compilerAnnotation = (YangCompilerAnnotation)curData;
        compilerAnnotation.setYangAppDataStructure(appDataStructure);
        listener.getParsedDataStack().push(appDataStructure);
    }

    public static void processAppDataStructureExit(TreeWalkListener listener, GeneratedYangParser.AppDataStructureStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.APP_DATA_STRUCTURE, "", ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangAppDataStructure)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.APP_DATA_STRUCTURE, "", ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

