/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.linker.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.ResolvableType;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangReferenceResolver;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.linker.YangLinker;
import org.onosproject.yang.compiler.linker.exceptions.LinkerException;
import org.onosproject.yang.compiler.linker.impl.YangLinkerUtils;

public class YangLinkerManager
implements YangLinker {
    private Set<YangNode> yangNodeSet = new HashSet<YangNode>();

    public Set<YangNode> getYangNodeSet() {
        return this.yangNodeSet;
    }

    public void createYangNodeSet(Set<YangNode> yangNodeSet) {
        this.getYangNodeSet().addAll(yangNodeSet);
    }

    @Override
    public void resolveDependencies(Set<YangNode> yangNodeSet) {
        this.createYangNodeSet(yangNodeSet);
        this.linkSubModulesToParentModule(yangNodeSet);
        this.addRefToYangFilesImportList(yangNodeSet);
        this.addRefToYangFilesIncludeList(yangNodeSet);
        YangLinkerUtils.updateFilePriority(yangNodeSet);
        this.processInterFileLinking(yangNodeSet);
        this.processUniqueLinking(yangNodeSet);
    }

    public void linkSubModulesToParentModule(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangSubModule)) continue;
            try {
                ((YangSubModule)yangNode).linkWithModule(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void addRefToYangFilesImportList(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangReferenceResolver)) continue;
            try {
                ((YangReferenceResolver)((Object)yangNode)).addReferencesToImportList(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void addRefToYangFilesIncludeList(Set<YangNode> yangNodeSet) throws LinkerException {
        for (YangNode yangNode : yangNodeSet) {
            if (!(yangNode instanceof YangReferenceResolver)) continue;
            try {
                ((YangReferenceResolver)((Object)yangNode)).addReferencesToIncludeList(this.getYangNodeSet());
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void processInterFileLinking(Set<YangNode> yangNodeSet) throws LinkerException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(yangNodeSet);
        Collections.sort(yangNodeSortedList);
        for (YangNode yangNode : yangNodeSortedList) {
            try {
                YangReferenceResolver resolver = (YangReferenceResolver)((Object)yangNode);
                resolver.resolveInterFileLinking(ResolvableType.YANG_IF_FEATURE);
                resolver.resolveInterFileLinking(ResolvableType.YANG_USES);
                resolver.resolveInterFileLinking(ResolvableType.YANG_AUGMENT);
                resolver.resolveInterFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                resolver.resolveInterFileLinking(ResolvableType.YANG_BASE);
                resolver.resolveInterFileLinking(ResolvableType.YANG_IDENTITYREF);
                resolver.resolveInterFileLinking(ResolvableType.YANG_LEAFREF);
                resolver.resolveInterFileLinking(ResolvableType.YANG_COMPILER_ANNOTATION);
                resolver.resolveInterFileLinking(ResolvableType.YANG_DEVIATION);
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
            catch (LinkerException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }

    public void processUniqueLinking(Set<YangNode> nodeSet) throws LinkerException {
        LinkedList<YangNode> list = new LinkedList<YangNode>();
        list.addAll(nodeSet);
        Collections.sort(list);
        for (YangNode yangNode : list) {
            try {
                YangReferenceResolver resolver = (YangReferenceResolver)((Object)yangNode);
                resolver.resolveUniqueLinking();
            }
            catch (DataModelException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
            catch (LinkerException e) {
                String errorInfo = "Error in file: " + yangNode.getName() + " in " + yangNode.getFileName() + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine() + "\n" + e.getLocalizedMessage();
                throw new LinkerException(errorInfo);
            }
        }
    }
}

