/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangInt64
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangInt64>,
Serializable {
    private static final long serialVersionUID = 8006201665L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final Long MIN_VALUE = Long.MIN_VALUE;
    public static final long MAX_VALUE = Long.MAX_VALUE;
    private final long value;

    public YangInt64(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = MIN_VALUE;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = Long.MAX_VALUE;
        } else {
            try {
                this.value = Long.parseLong(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid int64.");
            }
        }
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangInt64 anotherYangInt64) {
        return Long.compare(this.value, anotherYangInt64.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.INT64;
    }
}

