/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils.builtindatatype;

import java.io.Serializable;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangBuiltInDataTypeInfo;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public class YangInt32
extends DefaultLocationInfo
implements YangBuiltInDataTypeInfo<YangInt32>,
Serializable {
    private static final long serialVersionUID = 8006201666L;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private final int value;

    public YangInt32(String valueInString) {
        if (valueInString.matches(MIN_KEYWORD)) {
            this.value = Integer.MIN_VALUE;
        } else if (valueInString.matches(MAX_KEYWORD)) {
            this.value = Integer.MAX_VALUE;
        } else {
            try {
                this.value = Integer.parseInt(valueInString);
            }
            catch (Exception e) {
                throw new DataTypeException("YANG file error : Input value \"" + valueInString + "\" is not a valid int32.");
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int compareTo(YangInt32 anotherYangInt32) {
        return Integer.compare(this.value, anotherYangInt32.value);
    }

    @Override
    public YangDataTypes getYangType() {
        return YangDataTypes.INT32;
    }
}

