/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel.utils;

import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.BuiltInTypeObjectFactory;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;

public final class RestrictionResolver {
    private static final String PIPE = "|";
    private static final String ADD = "+";
    private static final String EMPTY_STRING = "";
    private static final String INTERVAL = "..";
    private static final int MAX_RANGE_BOUNDARY = 2;
    private static final int MIN_RANGE_BOUNDARY = 1;
    private static final String MIN_KEYWORD = "min";
    private static final String MAX_KEYWORD = "max";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";

    private RestrictionResolver() {
    }

    public static YangRangeRestriction processRangeRestriction(YangRangeRestriction refRr, int line, int position, boolean hasRefR, YangRangeRestriction curRr, YangDataTypes type, String fileName) throws DataModelException {
        return RestrictionResolver.getRestriction(refRr, line, position, hasRefR, curRr, fileName, type, YangConstructType.RANGE_DATA);
    }

    public static YangRangeRestriction processLengthRes(YangRangeRestriction refLr, int line, int position, boolean hasRefR, YangRangeRestriction curLr, String fileName) throws DataModelException {
        return RestrictionResolver.getRestriction(refLr, line, position, hasRefR, curLr, fileName, YangDataTypes.UINT64, YangConstructType.LENGTH_DATA);
    }

    private static YangRangeRestriction getRestriction(YangRangeRestriction refR, int line, int position, boolean hasRefR, YangRangeRestriction curR, String fileName, YangDataTypes type, YangConstructType conType) throws DataModelException {
        String[] rangeArguments;
        String rangeArg = RestrictionResolver.removeQuotesAndHandleConcat(curR.getRangeValue());
        for (String rangePart : rangeArguments = rangeArg.trim().split(Pattern.quote(PIPE))) {
            Object endValue;
            Object startValue;
            String endInterval;
            String startInterval;
            YangRangeInterval rangeInterval = new YangRangeInterval();
            rangeInterval.setCharPosition(position);
            rangeInterval.setLineNumber(line);
            rangeInterval.setFileName(fileName);
            String[] rangeBoundary = rangePart.trim().split(Pattern.quote(INTERVAL));
            if (rangeBoundary.length > 2) {
                DataModelException ex = new DataModelException("YANG file error : " + YangConstructType.getYangConstructType(conType) + SPACE + rangeArg + " is not valid.");
                ex.setLine(line);
                ex.setCharPosition(position);
                ex.setFileName(fileName);
                throw ex;
            }
            if (rangeBoundary.length == 1) {
                startInterval = rangeBoundary[0].trim();
                endInterval = rangeBoundary[0].trim();
            } else {
                startInterval = rangeBoundary[0].trim();
                endInterval = rangeBoundary[1].trim();
            }
            try {
                startValue = hasRefR && startInterval.equals(MIN_KEYWORD) && refR.getMinRestrictedValue() != null ? refR.getMinRestrictedValue() : (hasRefR && startInterval.equals(MAX_KEYWORD) && refR.getMaxRestrictedValue() != null ? refR.getMaxRestrictedValue() : BuiltInTypeObjectFactory.getDataObjectFromString(startInterval, type));
                endValue = hasRefR && endInterval.equals(MIN_KEYWORD) && refR.getMinRestrictedValue() != null ? refR.getMinRestrictedValue() : (hasRefR && endInterval.equals(MAX_KEYWORD) && refR.getMaxRestrictedValue() != null ? refR.getMaxRestrictedValue() : BuiltInTypeObjectFactory.getDataObjectFromString(endInterval, type));
            }
            catch (Exception e) {
                DataModelException ex = new DataModelException(e.getMessage());
                ex.setLine(line);
                ex.setCharPosition(position);
                ex.setFileName(fileName);
                throw ex;
            }
            rangeInterval.setStartValue(startValue);
            rangeInterval.setEndValue(endValue);
            try {
                curR.addRangeRestrictionInterval(rangeInterval);
            }
            catch (DataModelException ex) {
                ex.setLine(line);
                ex.setCharPosition(position);
                ex.setFileName(fileName);
                throw ex;
            }
        }
        return curR;
    }

    private static String removeQuotesAndHandleConcat(String yangStringData) {
        yangStringData = yangStringData.replace(QUOTE, EMPTY_STRING);
        String[] tmpData = yangStringData.split(Pattern.quote(ADD));
        StringBuilder builder = new StringBuilder();
        for (String yangString : tmpData) {
            builder.append(yangString);
        }
        return builder.toString();
    }
}

