/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.ListIterator;
import org.onosproject.yang.compiler.datamodel.BuiltInTypeObjectFactory;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.Resolvable;
import org.onosproject.yang.compiler.datamodel.YangBinary;
import org.onosproject.yang.compiler.datamodel.YangBits;
import org.onosproject.yang.compiler.datamodel.YangDecimal64;
import org.onosproject.yang.compiler.datamodel.YangDerivedInfo;
import org.onosproject.yang.compiler.datamodel.YangEnum;
import org.onosproject.yang.compiler.datamodel.YangEnumeration;
import org.onosproject.yang.compiler.datamodel.YangLeafRef;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangStringRestriction;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.YangUnion;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.ResolvableStatus;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.DataTypeException;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypeUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangUint64;

public class YangType<T>
extends DefaultLocationInfo
implements Cloneable,
Parsable,
Resolvable,
Serializable {
    private static final long serialVersionUID = 8062016054L;
    private YangNodeIdentifier nodeId = new YangNodeIdentifier();
    private YangDataTypes dataType;
    private T dataTypeExtendedInfo;
    private ResolvableStatus resolvableStatus = ResolvableStatus.UNRESOLVED;
    private boolean isTypeForInterFileGroupingResolution;
    private boolean isTypeNotResolvedTillRootNode;

    public String getPrefix() {
        return this.nodeId.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.nodeId.setPrefix(prefix);
    }

    public String getDataTypeName() {
        return this.nodeId.getName();
    }

    public void setDataTypeName(String typeName) {
        this.nodeId.setName(typeName);
    }

    public YangDataTypes getDataType() {
        return this.dataType;
    }

    public void setDataType(YangDataTypes dataType) {
        this.dataType = dataType;
    }

    public T getDataTypeExtendedInfo() {
        return this.dataTypeExtendedInfo;
    }

    public void setDataTypeExtendedInfo(T dataTypeInfo) {
        this.dataTypeExtendedInfo = dataTypeInfo;
    }

    public YangNodeIdentifier getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(YangNodeIdentifier nodeId) {
        this.nodeId = nodeId;
    }

    public void resetYangType() {
        this.nodeId = new YangNodeIdentifier();
        this.resolvableStatus = ResolvableStatus.UNRESOLVED;
        this.dataType = null;
        this.dataTypeExtendedInfo = null;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.TYPE_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    @Override
    public ResolvableStatus getResolvableStatus() {
        return this.resolvableStatus;
    }

    @Override
    public void setResolvableStatus(ResolvableStatus resolvableStatus) {
        this.resolvableStatus = resolvableStatus;
    }

    public Object resolve() throws DataModelException {
        if (this.getDataType() != YangDataTypes.DERIVED) {
            throw new DataModelException("Linker Error: Resolve should only be called for derived data types.  in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        YangDerivedInfo derivedInfo = (YangDerivedInfo)this.getDataTypeExtendedInfo();
        if (derivedInfo == null) {
            throw new DataModelException("Linker Error: Derived information is missing.  in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        try {
            this.setResolvableStatus(derivedInfo.resolve());
        }
        catch (DataModelException e) {
            throw new DataModelException(e.getMessage());
        }
        return null;
    }

    void isValidValue(String value) throws DataModelException {
        switch (this.getDataType()) {
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UINT8: 
            case UINT16: 
            case UINT32: 
            case UINT64: {
                if (this.getDataTypeExtendedInfo() == null) {
                    BuiltInTypeObjectFactory.getDataObjectFromString(value, this.getDataType());
                    break;
                }
                if (((YangRangeRestriction)this.getDataTypeExtendedInfo()).isValidValueString(value)) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case DECIMAL64: {
                YangDecimal64 decimal64 = (YangDecimal64)this.getDataTypeExtendedInfo();
                this.validateDecimal64(value, decimal64.getFractionDigit(), (YangRangeRestriction)decimal64.getRangeRestrictedExtendedInfo());
                break;
            }
            case STRING: {
                if (this.getDataTypeExtendedInfo() == null || ((YangStringRestriction)this.getDataTypeExtendedInfo()).isValidStringOnLengthRestriction(value) && ((YangStringRestriction)this.getDataTypeExtendedInfo()).isValidStringOnPatternRestriction(value)) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case BOOLEAN: {
                if (value.equals("true") || value.equals("false")) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case ENUMERATION: {
                Iterator iterator = ((YangEnumeration)this.getDataTypeExtendedInfo()).getEnumSet().iterator();
                boolean isValidated = false;
                while (iterator.hasNext()) {
                    YangEnum enumTemp = (YangEnum)iterator.next();
                    if (!enumTemp.getNamedValue().equals(value)) continue;
                    isValidated = true;
                    break;
                }
                if (isValidated) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case BITS: {
                YangBits bits = (YangBits)this.getDataTypeExtendedInfo();
                if (bits.fromString(value) != null) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case BINARY: {
                if (this.isValidBinary(value, (YangRangeRestriction)this.getDataTypeExtendedInfo())) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case LEAFREF: {
                YangLeafRef leafRef = (YangLeafRef)this.getDataTypeExtendedInfo();
                leafRef.validateDataOnExit();
                break;
            }
            case IDENTITYREF: {
                break;
            }
            case EMPTY: {
                if (value.length() <= 0) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not allowed for a data type " + (Object)((Object)this.getDataType()));
            }
            case UNION: {
                ListIterator<YangType<?>> listIterator = ((YangUnion)this.getDataTypeExtendedInfo()).getTypeList().listIterator();
                boolean isValidated = false;
                while (listIterator.hasNext()) {
                    YangType<?> type = listIterator.next();
                    try {
                        type.isValidValue(value);
                        isValidated = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (isValidated) break;
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)this.getDataType()));
            }
            case INSTANCE_IDENTIFIER: {
                break;
            }
            case DERIVED: {
                YangDataTypes dataType = ((YangDerivedInfo)this.getDataTypeExtendedInfo()).getEffectiveBuiltInType();
                if (YangDataTypeUtils.isOfRangeRestrictedType(dataType)) {
                    if (((YangDerivedInfo)this.getDataTypeExtendedInfo()).getResolvedExtendedInfo() == null) {
                        BuiltInTypeObjectFactory.getDataObjectFromString(value, ((YangDerivedInfo)this.getDataTypeExtendedInfo()).getEffectiveBuiltInType());
                        break;
                    }
                    if (((YangRangeRestriction)((YangDerivedInfo)this.getDataTypeExtendedInfo()).getResolvedExtendedInfo()).isValidValueString(value)) break;
                    throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)dataType));
                }
                if (dataType == YangDataTypes.STRING) {
                    YangStringRestriction stringRestriction;
                    Object info = ((YangDerivedInfo)this.getDataTypeExtendedInfo()).getResolvedExtendedInfo();
                    if (info == null || !(info instanceof YangStringRestriction) || (stringRestriction = (YangStringRestriction)info).isValidStringOnLengthRestriction(value) && stringRestriction.isValidStringOnPatternRestriction(value)) break;
                    throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)dataType));
                }
                if (dataType == YangDataTypes.BITS) {
                    YangTypeDef prevTypedef = ((YangDerivedInfo)this.getDataTypeExtendedInfo()).getReferredTypeDef();
                    YangType<?> type = prevTypedef.getTypeList().iterator().next();
                    YangBits bits = (YangBits)type.getDataTypeExtendedInfo();
                    if (bits.fromString(value) != null) break;
                    throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)dataType));
                }
                if (dataType == YangDataTypes.BINARY) {
                    if (this.isValidBinary(value, (YangRangeRestriction)((YangDerivedInfo)this.getDataTypeExtendedInfo()).getResolvedExtendedInfo())) break;
                    throw new DataTypeException("YANG file error : Input value \"" + value + "\" is not a valid " + (Object)((Object)dataType));
                }
                if (dataType != YangDataTypes.DECIMAL64) break;
                YangDerivedInfo derivedInfo = (YangDerivedInfo)this.getDataTypeExtendedInfo();
                YangTypeDef typedef = derivedInfo.getReferredTypeDef();
                YangType<?> decimal64Type = typedef.getTypeList().iterator().next();
                YangDecimal64 decimal64 = (YangDecimal64)decimal64Type.getDataTypeExtendedInfo();
                this.validateDecimal64(value, decimal64.getFractionDigit(), (YangRangeRestriction)decimal64.getRangeRestrictedExtendedInfo());
                break;
            }
            default: {
                throw new DataTypeException("YANG file error : Input value \"" + value + "\" received for unsupported data type " + (Object)((Object)this.getDataType()));
            }
        }
    }

    private void validateDecimal64(String value, int fractionDigit, YangRangeRestriction rangeRestriction) throws DataModelException {
        YangDecimal64 decimal64 = YangDecimal64.fromString(value);
        decimal64.setFractionDigit(fractionDigit);
        decimal64.setRangeRestrictedExtendedInfo(rangeRestriction);
        decimal64.validateDecimal64();
    }

    private boolean isValidBinary(String value, YangRangeRestriction lengthRestriction) {
        YangBinary binary = new YangBinary(value);
        if (binary.getBinaryData().length == 0) {
            return false;
        }
        if (lengthRestriction == null || lengthRestriction.getAscendingRangeIntervals() == null || lengthRestriction.getAscendingRangeIntervals().isEmpty()) {
            return true;
        }
        ListIterator rangeListIterator = lengthRestriction.getAscendingRangeIntervals().listIterator();
        boolean isMatched = false;
        while (rangeListIterator.hasNext()) {
            YangRangeInterval rangeInterval = rangeListIterator.next();
            rangeInterval.setFileName(this.getFileName());
            rangeInterval.setLineNumber(this.getLineNumber());
            rangeInterval.setCharPosition(this.getCharPosition());
            BigInteger startValue = ((YangUint64)rangeInterval.getStartValue()).getValue();
            BigInteger endValue = ((YangUint64)rangeInterval.getEndValue()).getValue();
            if (binary.toString().length() < startValue.intValue() || binary.toString().length() > endValue.intValue()) continue;
            isMatched = true;
            break;
        }
        return isMatched;
    }

    public boolean isTypeForInterFileGroupingResolution() {
        return this.isTypeForInterFileGroupingResolution;
    }

    public void setTypeForInterFileGroupingResolution(boolean typeForInterFileGroupingResolution) {
        this.isTypeForInterFileGroupingResolution = typeForInterFileGroupingResolution;
    }

    public boolean isTypeNotResolvedTillRootNode() {
        return this.isTypeNotResolvedTillRootNode;
    }

    public void setTypeNotResolvedTillRootNode(boolean typeNotResolvedTillRootNode) {
        this.isTypeNotResolvedTillRootNode = typeNotResolvedTillRootNode;
    }

    public YangType<T> clone() throws CloneNotSupportedException {
        YangType clonedNode = (YangType)super.clone();
        return clonedNode;
    }
}

