/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangDesc;
import org.onosproject.yang.compiler.datamodel.YangPatternRestriction;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangReference;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangUint64;

public class YangStringRestriction
extends DefaultLocationInfo
implements YangDesc,
YangReference,
Serializable {
    private static final long serialVersionUID = 8062016053L;
    private YangRangeRestriction<YangUint64> lengthRestriction;
    private List<YangPatternRestriction> patternResList;
    private String reference;
    private String description;

    public YangRangeRestriction<YangUint64> getLengthRestriction() {
        return this.lengthRestriction;
    }

    public void setLengthRestriction(YangRangeRestriction<YangUint64> rest) {
        this.lengthRestriction = rest;
    }

    public List<YangPatternRestriction> getPatternResList() {
        return this.patternResList;
    }

    void setPatternResList(List<YangPatternRestriction> restList) {
        this.patternResList = restList;
    }

    public void addPaternRes(YangPatternRestriction patRes) {
        if (this.patternResList == null) {
            this.patternResList = new LinkedList<YangPatternRestriction>();
        }
        this.patternResList.add(patRes);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public void setReference(String ref) {
        this.reference = ref;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    boolean isValidStringOnLengthRestriction(String valueInString) {
        if (this.lengthRestriction == null || this.lengthRestriction.getAscendingRangeIntervals() == null || this.lengthRestriction.getAscendingRangeIntervals().isEmpty()) {
            return true;
        }
        ListIterator<YangRangeInterval<YangUint64>> rangeListIterator = this.lengthRestriction.getAscendingRangeIntervals().listIterator();
        boolean isMatched = false;
        while (rangeListIterator.hasNext()) {
            YangRangeInterval<YangUint64> rangeInterval = rangeListIterator.next();
            rangeInterval.setCharPosition(this.getCharPosition());
            rangeInterval.setLineNumber(this.getLineNumber());
            rangeInterval.setFileName(this.getFileName());
            BigInteger startValue = rangeInterval.getStartValue().getValue();
            BigInteger endValue = rangeInterval.getEndValue().getValue();
            if (valueInString.length() < startValue.intValue() || valueInString.length() > endValue.intValue()) continue;
            isMatched = true;
            break;
        }
        return isMatched;
    }

    boolean isValidStringOnPatternRestriction(String valueInString) {
        if (this.patternResList == null || this.patternResList.isEmpty()) {
            return true;
        }
        ListIterator<YangPatternRestriction> it = this.patternResList.listIterator();
        boolean isMatched = false;
        while (it.hasNext()) {
            if (!valueInString.matches(it.next().getPattern())) continue;
            isMatched = true;
            break;
        }
        return isMatched;
    }
}

