/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;

public class YangInclude
extends DefaultLocationInfo
implements Parsable,
Serializable {
    private static final long serialVersionUID = 806201644L;
    private String subModuleName;
    private Date revision;
    private YangNode includedNode;

    public String getSubModuleName() {
        return this.subModuleName;
    }

    public void setSubModuleName(String subModuleName) {
        this.subModuleName = subModuleName;
    }

    public Date getRevision() {
        return this.revision;
    }

    public void setRevision(Date revision) {
        this.revision = revision;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.INCLUDE_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    public YangNode getIncludedNode() {
        return this.includedNode;
    }

    public void setIncludedNode(YangNode includedNode) {
        this.includedNode = includedNode;
    }

    public YangSubModule addReferenceToInclude(Set<YangNode> yangNodeSet) throws DataModelException {
        String includedSubModuleName = this.getSubModuleName();
        Date includedSubModuleRevision = this.getRevision();
        YangNode subModuleNode = null;
        if (includedSubModuleRevision != null) {
            String includedSubModuleNameWithRevision = includedSubModuleName + "@" + includedSubModuleRevision;
            subModuleNode = DataModelUtils.findReferredNode(yangNodeSet, includedSubModuleNameWithRevision);
        }
        if (subModuleNode == null) {
            subModuleNode = DataModelUtils.findReferredNode(yangNodeSet, includedSubModuleName);
        }
        if (subModuleNode != null && subModuleNode instanceof YangSubModule) {
            if (this.getRevision() == null) {
                this.setIncludedNode(subModuleNode);
                return (YangSubModule)subModuleNode;
            }
            if (subModuleNode.getRevision() != null && subModuleNode.getRevision().getRevDate().equals(includedSubModuleRevision)) {
                this.setIncludedNode(subModuleNode);
                return (YangSubModule)subModuleNode;
            }
        }
        DataModelException exception = new DataModelException("YANG file error : Included sub module " + includedSubModuleName + "with a given revision is not found.");
        exception.setLine(this.getLineNumber());
        exception.setCharPosition(this.getCharPosition());
        exception.setFileName(this.getFileName());
        throw exception;
    }

    public void reportIncludeError() throws DataModelException {
        DataModelException exception = new DataModelException("YANG file error : Included sub-module " + this.getSubModuleName() + "doesn't belongs to parent module also it doesn't belongsto sub-module belonging to the same parent module.");
        exception.setLine(this.getLineNumber());
        exception.setCharPosition(this.getCharPosition());
        exception.setFileName(this.getFileName());
        throw exception;
    }
}

