/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.compiler.datamodel.DefaultLocationInfo;
import org.onosproject.yang.compiler.datamodel.YangDecimal64;
import org.onosproject.yang.compiler.datamodel.YangPatternRestriction;
import org.onosproject.yang.compiler.datamodel.YangRangeInterval;
import org.onosproject.yang.compiler.datamodel.YangRangeRestriction;
import org.onosproject.yang.compiler.datamodel.YangStringRestriction;
import org.onosproject.yang.compiler.datamodel.YangType;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.exceptions.ErrorMessages;
import org.onosproject.yang.compiler.datamodel.utils.ResolvableStatus;
import org.onosproject.yang.compiler.datamodel.utils.RestrictionResolver;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypeUtils;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yang.compiler.datamodel.utils.builtindatatype.YangUint64;

public class YangDerivedInfo<T>
extends DefaultLocationInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 806201641L;
    private YangTypeDef referredTypeDef;
    private T resolvedExtendedInfo;
    private YangDataTypes effectiveBuiltInType;
    private YangRangeRestriction lengthRes;
    private YangRangeRestriction rangeRes;
    private List<YangPatternRestriction> patternResList;

    public YangTypeDef getReferredTypeDef() {
        return this.referredTypeDef;
    }

    public void setReferredTypeDef(YangTypeDef referredTypeDef) {
        this.referredTypeDef = referredTypeDef;
    }

    public T getResolvedExtendedInfo() {
        return this.resolvedExtendedInfo;
    }

    public YangRangeRestriction getLengthRes() {
        return this.lengthRes;
    }

    public void setLengthRes(YangRangeRestriction lr) {
        this.lengthRes = lr;
    }

    public YangRangeRestriction getRangeRes() {
        return this.rangeRes;
    }

    public void setRangeRes(YangRangeRestriction rr) {
        this.rangeRes = rr;
    }

    public List<YangPatternRestriction> getPatternResList() {
        return this.patternResList;
    }

    public void addPatternRes(YangPatternRestriction pr) {
        if (this.patternResList == null) {
            this.patternResList = new LinkedList<YangPatternRestriction>();
        }
        this.patternResList.add(pr);
    }

    public YangDataTypes getEffectiveBuiltInType() {
        return this.effectiveBuiltInType;
    }

    public ResolvableStatus resolve() throws DataModelException {
        YangType<?> baseType = this.getReferredTypeDef().getTypeDefBaseType();
        YangDataTypes type = baseType.getDataType();
        Object extended = baseType.getDataTypeExtendedInfo();
        if (type == YangDataTypes.DERIVED) {
            ResolvableStatus resolvableStatus = this.resolveTypeDerivedInfo(baseType);
            if (resolvableStatus != null) {
                return resolvableStatus;
            }
        } else {
            if (type == YangDataTypes.LEAFREF || type == YangDataTypes.IDENTITYREF) {
                this.effectiveBuiltInType = type;
                return ResolvableStatus.RESOLVED;
            }
            this.effectiveBuiltInType = type;
            if (YangDataTypeUtils.isOfRangeRestrictedType(this.effectiveBuiltInType)) {
                return this.getResolveStatusForRangeRestrictionType(extended);
            }
            if (this.effectiveBuiltInType == YangDataTypes.STRING) {
                return this.getResolveStatusForString(extended);
            }
            if (this.effectiveBuiltInType == YangDataTypes.BINARY) {
                return this.getResolveStatusForBinary(extended);
            }
            if (this.effectiveBuiltInType == YangDataTypes.DECIMAL64) {
                return this.getResolveStatusForDecimal64(extended);
            }
        }
        if (this.effectiveBuiltInType.isNonRestrictedType()) {
            if (this.lengthRes == null && this.rangeRes == null && (this.patternResList == null || this.patternResList.isEmpty())) {
                return ResolvableStatus.RESOLVED;
            }
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error: Restrictions can't be applied to a given type ", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
        }
        throw new DataModelException(ErrorMessages.getErrorMsg("Linker error: Unable to process the derived type. ", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
    }

    private ResolvableStatus getResolveStatusForRangeRestrictionType(T extended) throws DataModelException {
        if (extended == null) {
            this.resolveRangeRestriction(null);
            return ResolvableStatus.RESOLVED;
        }
        if (!(extended instanceof YangRangeRestriction)) {
            this.throwError();
        }
        this.resolveRangeRestriction((YangRangeRestriction)extended);
        return ResolvableStatus.RESOLVED;
    }

    private ResolvableStatus getResolveStatusForString(T extended) throws DataModelException {
        if (extended == null) {
            this.resolveStringRestriction(null);
            return ResolvableStatus.RESOLVED;
        }
        if (!(extended instanceof YangStringRestriction)) {
            this.throwError();
        }
        this.resolveStringRestriction((YangStringRestriction)extended);
        return ResolvableStatus.RESOLVED;
    }

    private ResolvableStatus getResolveStatusForBinary(T extended) throws DataModelException {
        if (extended == null) {
            this.resolveBinaryRestriction(null);
            return ResolvableStatus.RESOLVED;
        }
        if (!(extended instanceof YangRangeRestriction)) {
            this.throwError();
        }
        this.resolveBinaryRestriction((YangRangeRestriction)extended);
        return ResolvableStatus.RESOLVED;
    }

    private ResolvableStatus getResolveStatusForDecimal64(T extended) throws DataModelException {
        if (extended != null) {
            if (((YangDecimal64)extended).getRangeRestrictedExtendedInfo() == null) {
                this.resolveRangeRestriction(null);
                return ResolvableStatus.RESOLVED;
            }
            if (!(((YangDecimal64)extended).getRangeRestrictedExtendedInfo() instanceof YangRangeRestriction)) {
                this.throwError();
            }
            this.resolveRangeRestriction((YangRangeRestriction)((YangDecimal64)extended).getRangeRestrictedExtendedInfo());
            return ResolvableStatus.RESOLVED;
        }
        throw new DataModelException(ErrorMessages.getErrorMsg("Linker error: Unable to find type extended info for decimal64.", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
    }

    private void throwError() throws DataModelException {
        throw new DataModelException(ErrorMessages.getErrorMsg("Linker error: Referred typedef restriction info is of invalid ", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName() + "\""));
    }

    private ResolvableStatus resolveTypeDerivedInfo(YangType<?> baseType) throws DataModelException {
        if (baseType.getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && baseType.getResolvableStatus() != ResolvableStatus.RESOLVED) {
            this.throwError();
        }
        if (this.getReferredTypeDef().getTypeDefBaseType().getResolvableStatus() == ResolvableStatus.INTRA_FILE_RESOLVED) {
            return ResolvableStatus.INTRA_FILE_RESOLVED;
        }
        this.effectiveBuiltInType = ((YangDerivedInfo)baseType.getDataTypeExtendedInfo()).getEffectiveBuiltInType();
        YangDerivedInfo refDerivedInfo = (YangDerivedInfo)baseType.getDataTypeExtendedInfo();
        T extendedInfo = refDerivedInfo.getResolvedExtendedInfo();
        if (YangDataTypeUtils.isOfRangeRestrictedType(this.effectiveBuiltInType)) {
            return this.getResolveStatusForRangeRestrictionType(extendedInfo);
        }
        if (this.effectiveBuiltInType == YangDataTypes.STRING) {
            return this.getResolveStatusForString(extendedInfo);
        }
        if (this.effectiveBuiltInType == YangDataTypes.BINARY) {
            return this.getResolveStatusForBinary(extendedInfo);
        }
        if (this.effectiveBuiltInType == YangDataTypes.DECIMAL64) {
            if (extendedInfo == null) {
                this.resolveRangeRestriction(null);
                return ResolvableStatus.RESOLVED;
            }
            if (!(extendedInfo instanceof YangRangeRestriction)) {
                this.throwError();
            }
            this.resolveRangeRestriction((YangRangeRestriction)extendedInfo);
            return ResolvableStatus.RESOLVED;
        }
        return null;
    }

    private void resolveStringRestriction(YangStringRestriction refSr) throws DataModelException {
        YangStringRestriction curSr = null;
        YangRangeRestriction<YangUint64> refRr = null;
        List<YangPatternRestriction> refPr = null;
        if (this.rangeRes != null) {
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error: Range restriction should't be present for string data type.", ".", this.getLineNumber(), this.getCharPosition(), this.getFileName()));
        }
        if (refSr == null && this.lengthRes == null && (this.patternResList == null || this.patternResList.isEmpty())) {
            return;
        }
        if (refSr != null) {
            refRr = refSr.getLengthRestriction();
            refPr = refSr.getPatternResList();
        }
        YangRangeRestriction lr = this.resolveLengthRestriction(refRr);
        List<YangPatternRestriction> pr = this.resolvePatternRestriction(refPr);
        if (lr != null || pr != null) {
            curSr = new YangStringRestriction();
            curSr.setCharPosition(this.getCharPosition());
            curSr.setFileName(this.getFileName());
            curSr.setLineNumber(this.getLineNumber());
            curSr.setLengthRestriction(lr);
            curSr.setPatternResList(pr);
        }
        this.resolvedExtendedInfo = curSr;
    }

    private void resolveBinaryRestriction(YangRangeRestriction refLr) throws DataModelException {
        if (this.rangeRes != null || this.patternResList != null && !this.patternResList.isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error: for binary range restriction or pattern restriction is not allowed.", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName()));
        }
        YangRangeRestriction lr = this.resolveLengthRestriction(refLr);
        this.resolvedExtendedInfo = lr;
    }

    private List<YangPatternRestriction> resolvePatternRestriction(List<YangPatternRestriction> refPr) {
        if ((refPr == null || refPr.isEmpty()) && (this.patternResList == null || this.patternResList.isEmpty())) {
            return null;
        }
        if (this.patternResList == null || this.patternResList.isEmpty()) {
            return refPr;
        }
        if (refPr == null || refPr.isEmpty()) {
            return this.patternResList;
        }
        for (YangPatternRestriction pattern : refPr) {
            this.addPatternRes(pattern);
        }
        return this.patternResList;
    }

    private YangRangeRestriction resolveLengthRestriction(YangRangeRestriction refLr) throws DataModelException {
        if (refLr == null && this.lengthRes == null) {
            return null;
        }
        if (this.lengthRes == null) {
            return refLr;
        }
        if (refLr == null) {
            return RestrictionResolver.processLengthRes(null, this.getLineNumber(), this.getCharPosition(), false, this.lengthRes, this.getFileName());
        }
        YangRangeRestriction curLr = RestrictionResolver.processLengthRes(refLr, this.getLineNumber(), this.getCharPosition(), true, this.lengthRes, this.getFileName());
        this.resolveLengthAndRangeRestriction(refLr, curLr);
        return curLr;
    }

    private void resolveLengthAndRangeRestriction(YangRangeRestriction refRestriction, YangRangeRestriction curRestriction) throws DataModelException {
        for (YangRangeInterval curInterval : curRestriction.getAscendingRangeIntervals()) {
            if (!(curInterval instanceof YangRangeInterval)) {
                throw new DataModelException(ErrorMessages.getErrorMsg("Linker error: Current range intervals not processed correctly.", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName()));
            }
            try {
                refRestriction.isValidInterval(curInterval, this.getFileName());
            }
            catch (DataModelException e) {
                throw new DataModelException(ErrorMessages.getErrorMsg(e.getMessage(), "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName()));
            }
        }
    }

    private void resolveRangeRestriction(YangRangeRestriction refRangeRestriction) throws DataModelException {
        if (this.lengthRes != null || this.patternResList != null && !this.patternResList.isEmpty()) {
            throw new DataModelException(ErrorMessages.getErrorMsg("YANG file error: Length/Pattern restriction should't be present for int/uint/decimal data type.", "type.", this.getLineNumber(), this.getCharPosition(), this.getFileName()));
        }
        if (refRangeRestriction == null && this.rangeRes == null) {
            return;
        }
        if (this.rangeRes == null) {
            this.resolvedExtendedInfo = refRangeRestriction;
            return;
        }
        if (refRangeRestriction == null) {
            YangRangeRestriction curRangeRestriction = RestrictionResolver.processRangeRestriction(null, this.getLineNumber(), this.getCharPosition(), false, this.rangeRes, this.effectiveBuiltInType, this.getFileName());
            this.resolvedExtendedInfo = curRangeRestriction;
            return;
        }
        YangRangeRestriction curRangeRestriction = RestrictionResolver.processRangeRestriction(refRangeRestriction, this.getLineNumber(), this.getCharPosition(), true, this.rangeRes, this.effectiveBuiltInType, this.getFileName());
        this.resolveLengthAndRangeRestriction(refRangeRestriction, curRangeRestriction);
        this.resolvedExtendedInfo = curRangeRestriction;
    }
}

