/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbtreebuilderforlisthavinglist.rev20160826.ytbtreebuilderforlisthavinglist.carrier.multiplexes;

/**
 * Represents ENUM data of typesEnum.
 */
public enum TypesEnum {

    /**
     * Represents space-division.
     */
    SPACE_DIVISION(0, "space-division"),

    /**
     * Represents frequency-division.
     */
    FREQUENCY_DIVISION(1, "frequency-division"),

    /**
     * Represents time-division.
     */
    TIME_DIVISION(3, "time-division");

    private int typesEnum;
    private String schemaName;

    /**
     * Creates an instance of typesEnum.
     *
     * @param typesEnum value of typesEnum
     */
     TypesEnum(int typesEnum, String schemaName) {
        this.typesEnum = typesEnum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of typesEnum for.
     *
     * @param value value of typesEnum for
     * @return typesEnum for
     */
    public static TypesEnum of(int value) {
        switch (value) {
            case 0:
                return TypesEnum.SPACE_DIVISION;
            case 1:
                return TypesEnum.FREQUENCY_DIVISION;
            case 3:
                return TypesEnum.TIME_DIVISION;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of typesEnum for.
     *
     * @param value value of typesEnum for
     * @return typesEnum for
     */
    public static TypesEnum of(String value) {
        switch (value) {
            case "space-division":
                return TypesEnum.SPACE_DIVISION;
            case "frequency-division":
                return TypesEnum.FREQUENCY_DIVISION;
            case "time-division":
                return TypesEnum.TIME_DIVISION;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute typesEnum.
     *
     * @return typesEnum value of typesEnum
     */
    public int typesEnum() {
        return typesEnum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
