/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content.contentinput.In;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of contentInput.
 */
public class DefaultContentInput extends InnerModelObject implements ContentInput {
    protected In in;

    @Override
    public In in() {
        return in;
    }

    @Override
    public void in(In in) {
        this.in = in;
    }

    @Override
    public int hashCode() {
        return Objects.hash(in);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultContentInput) {
            DefaultContentInput other = (DefaultContentInput) obj;
            return
                Objects.equals(in, other.in);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("in=" + in)
            .toString();
    }


    /**
     * Creates an instance of defaultContentInput.
     */
    public DefaultContentInput() {
    }

}