/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content;

import org.onosproject.yang.gen.v1.ytbrpc.rev20160826.ytbrpc.content.contentoutput.OutCh;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of contentOutput.
 */
public interface ContentOutput extends Augmentable  {

    /**
     * Returns the attribute outCh.
     *
     * @return outCh value of outCh
     */
    OutCh outCh();

    /**
     * Sets the attribute outCh.
     *
     * @param outCh value of outCh
     */
    void outCh(OutCh outCh);

}