/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmodulewithlist.rev20160826.ytbmodulewithlist;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of ytblistlist.
 */
public interface Ytblistlist extends Augmentable  {

    /**
     * Identify the leaf of Ytblistlist.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents prediction.
         */
        PREDICTION(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute prediction.
     *
     * @return prediction list of prediction
     */
    List<Find> prediction();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute prediction.
     *
     * @param prediction list of prediction
     */
    void prediction(List<Find> prediction);

    /**
     * Adds to the list of prediction.
     *
     * @param addTo value of prediction
     */
    void addToPrediction(Find addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}