/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Enum1Enum;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Enum2Enum;
import org.onosproject.yang.gen.v1.ytbietfschedule.rev20160826.ytbietfschedule.Monitor;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbIetfSchedule.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbIetfScheduleOpParam extends InnerModelObject implements YtbIetfSchedule {
    protected byte time;
    protected Enum1Enum enum1;
    protected List<Enum2Enum> enum2;
    protected BitSet valueLeafFlags = new BitSet();
    protected Monitor monitor;

    @Override
    public byte time() {
        return time;
    }

    @Override
    public Enum1Enum enum1() {
        return enum1;
    }

    @Override
    public List<Enum2Enum> enum2() {
        return enum2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Monitor monitor() {
        return monitor;
    }

    @Override
    public void time(byte time) {
        valueLeafFlags.set(LeafIdentifier.TIME.getLeafIndex());
        this.time = time;
    }

    @Override
    public void enum1(Enum1Enum enum1) {
        valueLeafFlags.set(LeafIdentifier.ENUM1.getLeafIndex());
        this.enum1 = enum1;
    }

    @Override
    public void enum2(List<Enum2Enum> enum2) {
        valueLeafFlags.set(LeafIdentifier.ENUM2.getLeafIndex());
        this.enum2 = enum2;
    }

    @Override
    public void monitor(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void addToEnum2(Enum2Enum addTo) {
        if (enum2 == null) {
            enum2 = new ArrayList<>();
        }
        enum2.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(time, enum1, enum2, valueLeafFlags, monitor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbIetfScheduleOpParam) {
            YtbIetfScheduleOpParam other = (YtbIetfScheduleOpParam) obj;
            return
                Objects.equals(time, other.time) &&
                Objects.equals(enum1, other.enum1) &&
                Objects.equals(enum2, other.enum2) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(monitor, other.monitor);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("time=" + time)
            .add("enum1=" + enum1)
            .add("enum2=" + enum2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("monitor=" + monitor)
            .toString();
    }

    /**
     * Creates an instance of ytbIetfScheduleOpParam.
     */
    public YtbIetfScheduleOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}