/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbemptytype.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ytbemptytype.rev20160826.ytbemptytype.EmpType;

/**
 * Abstraction of an entity which represents the functionality of ytbEmptyType.
 */
public interface YtbEmptyType {

    /**
     * Identify the leaf of YtbEmptyType.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents empty.
         */
        EMPTY(1),
        /**
         * Represents emptyRef.
         */
        EMPTYREF(2),
        /**
         * Represents emptyType.
         */
        EMPTYTYPE(3),
        /**
         * Represents emptyRefType.
         */
        EMPTYREFTYPE(4),
        /**
         * Represents emptyList.
         */
        EMPTYLIST(5),
        /**
         * Represents emptyListRef.
         */
        EMPTYLISTREF(6),
        /**
         * Represents emptyListType.
         */
        EMPTYLISTTYPE(7),
        /**
         * Represents emptyListRefType.
         */
        EMPTYLISTREFTYPE(8);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute empty.
     *
     * @return empty value of empty
     */
    boolean empty();

    /**
     * Returns the attribute emptyRef.
     *
     * @return emptyRef value of emptyRef
     */
    boolean emptyRef();

    /**
     * Returns the attribute emptyType.
     *
     * @return emptyType value of emptyType
     */
    EmpType emptyType();

    /**
     * Returns the attribute emptyRefType.
     *
     * @return emptyRefType value of emptyRefType
     */
    boolean emptyRefType();

    /**
     * Returns the attribute emptyList.
     *
     * @return emptyList list of emptyList
     */
    List<Boolean> emptyList();

    /**
     * Returns the attribute emptyListRef.
     *
     * @return emptyListRef list of emptyListRef
     */
    List<Boolean> emptyListRef();

    /**
     * Returns the attribute emptyListType.
     *
     * @return emptyListType list of emptyListType
     */
    List<EmpType> emptyListType();

    /**
     * Returns the attribute emptyListRefType.
     *
     * @return emptyListRefType list of emptyListRefType
     */
    List<Boolean> emptyListRefType();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute empty.
     *
     * @param empty value of empty
     */
    void empty(boolean empty);

    /**
     * Sets the attribute emptyRef.
     *
     * @param emptyRef value of emptyRef
     */
    void emptyRef(boolean emptyRef);

    /**
     * Sets the attribute emptyType.
     *
     * @param emptyType value of emptyType
     */
    void emptyType(EmpType emptyType);

    /**
     * Sets the attribute emptyRefType.
     *
     * @param emptyRefType value of emptyRefType
     */
    void emptyRefType(boolean emptyRefType);

    /**
     * Sets the attribute emptyList.
     *
     * @param emptyList list of emptyList
     */
    void emptyList(List<Boolean> emptyList);

    /**
     * Sets the attribute emptyListRef.
     *
     * @param emptyListRef list of emptyListRef
     */
    void emptyListRef(List<Boolean> emptyListRef);

    /**
     * Sets the attribute emptyListType.
     *
     * @param emptyListType list of emptyListType
     */
    void emptyListType(List<EmpType> emptyListType);

    /**
     * Sets the attribute emptyListRefType.
     *
     * @param emptyListRefType list of emptyListRefType
     */
    void emptyListRefType(List<Boolean> emptyListRefType);

    /**
     * Adds to the list of emptyList.
     *
     * @param addTo value of emptyList
     */
    void addToEmptyList(Boolean addTo);

    /**
     * Adds to the list of emptyListRef.
     *
     * @param addTo value of emptyListRef
     */
    void addToEmptyListRef(Boolean addTo);

    /**
     * Adds to the list of emptyListType.
     *
     * @param addTo value of emptyListType
     */
    void addToEmptyListType(EmpType addTo);

    /**
     * Adds to the list of emptyListRefType.
     *
     * @param addTo value of emptyListRefType
     */
    void addToEmptyListRefType(Boolean addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}