/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary;

import java.util.Base64;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of forunionUnion.
 */
public final class ForunionUnion {
    private byte[] binary;
    private byte int8;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of forunionUnion.
     */
    private ForunionUnion() {
    }

    /**
     * Creates an instance of binary.
     *
     * @param binary value of binary
     */
    public ForunionUnion(byte[] binary) {
        setValue.set(0);
        this.binary = binary;
    }

    /**
     * Creates an instance of int8.
     *
     * @param int8 value of int8
     */
    public ForunionUnion(byte int8) {
        setValue.set(1);
        this.int8 = int8;
    }

    /**
     * Returns the object of forunionUnion for type binary.
     *
     * @param value value of forunionUnion for type binary
     * @return forunionUnion for type binary
     */
    public static ForunionUnion of(byte[] value) {
        return new ForunionUnion(value);
    }

    /**
     * Returns the object of forunionUnion for type int8.
     *
     * @param value value of forunionUnion for type int8
     * @return forunionUnion for type int8
     */
    public static ForunionUnion of(byte value) {
        return new ForunionUnion(value);
    }

    /**
     * Returns the attribute binary.
     *
     * @return binary value of binary
     */
    public byte[] binary() {
        return binary;
    }
    /**
     * Returns the attribute int8.
     *
     * @return int8 value of int8
     */
    public byte int8() {
        return int8;
    }
    /**
     * Sets the attribute binary.
     *
     * @param binary value of binary
     */
    public void binary(byte[] binary) {
        this.binary = binary;
    }
    /**
     * Sets the attribute int8.
     *
     * @param int8 value of int8
     */
    public void int8(byte int8) {
        this.int8 = int8;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binary, int8);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ForunionUnion) {
            ForunionUnion other = (ForunionUnion) obj;
            return
                Objects.equals(binary, other.binary) &&
                Objects.equals(int8, other.int8);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return Base64.getEncoder().encodeToString(binary).toString();
        }
        if (setValue.get(1)) {
            return String.valueOf(int8);
        }
        return null;
    }
    /**
     * Returns the object of forunionUnion fromString input String forunionUnion.
     *
     * @param valInString value of input String
     * @return forunionUnion
     */
    public static ForunionUnion fromString(String valInString) {
        try {
            byte[] tmpVal = Base64.getDecoder().decode(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            byte tmpVal = Byte.parseByte(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
