/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary.derivedbitsb.Bits;
import java.util.Objects;

/**
 * Represents the implementation of derivedbitsb.
 */
public final class Derivedbitsb {

    private BitSet bits;

    /**
     * Creates an instance of derivedbitsb.
     */
    private Derivedbitsb() {
    }

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
    public Derivedbitsb(BitSet bits) {
        this.bits = bits;
    }

    /**
     * Returns the object of derivedbitsb for type bits.
     *
     * @param value value of derivedbitsb for type bits
     * @return derivedbitsb for type bits
     */
    public static Derivedbitsb of(BitSet value) {
        return new Derivedbitsb(value);
    }

    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public BitSet bits() {
        return bits;
    }
    /**
     * Sets the attribute bits.
     *
     * @param bits value of bits
     */
    public void bits(BitSet bits) {
        this.bits = bits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Derivedbitsb) {
            Derivedbitsb other = (Derivedbitsb) obj;
            return
                Objects.equals(bits, other.bits);
        }
        return false;
    }

    @Override
    public String toString() {
        return Bits.toString(bits);
    }
    /**
     * Returns the object of derivedbitsb fromString input String derivedbitsb.
     *
     * @param valInString value of input String
     * @return derivedbitsb
     */
    public static Derivedbitsb fromString(String valInString) {
        try {
            BitSet tmpVal = Bits.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
