/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary;

import java.util.Objects;

/**
 * Represents the implementation of derivedbinarya.
 */
public final class Derivedbinarya {

    private Derivedbinaryb derivedbinaryb;

    /**
     * Creates an instance of derivedbinarya.
     */
    private Derivedbinarya() {
    }

    /**
     * Creates an instance of derivedbinaryb.
     *
     * @param derivedbinaryb value of derivedbinaryb
     */
    public Derivedbinarya(Derivedbinaryb derivedbinaryb) {
        this.derivedbinaryb = derivedbinaryb;
    }

    /**
     * Returns the object of derivedbinarya for type derivedbinaryb.
     *
     * @param value value of derivedbinarya for type derivedbinaryb
     * @return derivedbinarya for type derivedbinaryb
     */
    public static Derivedbinarya of(Derivedbinaryb value) {
        return new Derivedbinarya(value);
    }

    /**
     * Returns the attribute derivedbinaryb.
     *
     * @return derivedbinaryb value of derivedbinaryb
     */
    public Derivedbinaryb derivedbinaryb() {
        return derivedbinaryb;
    }
    /**
     * Sets the attribute derivedbinaryb.
     *
     * @param derivedbinaryb value of derivedbinaryb
     */
    public void derivedbinaryb(Derivedbinaryb derivedbinaryb) {
        this.derivedbinaryb = derivedbinaryb;
    }

    @Override
    public int hashCode() {
        return Objects.hash(derivedbinaryb);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Derivedbinarya) {
            Derivedbinarya other = (Derivedbinarya) obj;
            return
                Objects.equals(derivedbinaryb, other.derivedbinaryb);
        }
        return false;
    }

    @Override
    public String toString() {
        return derivedbinaryb.toString();
    }
    /**
     * Returns the object of derivedbinarya fromString input String derivedbinarya.
     *
     * @param valInString value of input String
     * @return derivedbinarya
     */
    public static Derivedbinarya fromString(String valInString) {
        try {
            Derivedbinaryb tmpVal = Derivedbinaryb.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
