/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype;

import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.unionenumunion.UnionEnumUnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of unionEnumUnion.
 */
public final class UnionEnumUnion {
    private UnionEnumUnionEnum1 enumeration;
    private EnumDer1 enumDer1;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of unionEnumUnion.
     */
    private UnionEnumUnion() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public UnionEnumUnion(UnionEnumUnionEnum1 enumeration) {
        setValue.set(0);
        this.enumeration = enumeration;
    }

    /**
     * Creates an instance of enumDer1.
     *
     * @param enumDer1 value of enumDer1
     */
    public UnionEnumUnion(EnumDer1 enumDer1) {
        setValue.set(1);
        this.enumDer1 = enumDer1;
    }

    /**
     * Returns the object of unionEnumUnion for type enumeration.
     *
     * @param value value of unionEnumUnion for type enumeration
     * @return unionEnumUnion for type enumeration
     */
    public static UnionEnumUnion of(UnionEnumUnionEnum1 value) {
        return new UnionEnumUnion(value);
    }

    /**
     * Returns the object of unionEnumUnion for type enumDer1.
     *
     * @param value value of unionEnumUnion for type enumDer1
     * @return unionEnumUnion for type enumDer1
     */
    public static UnionEnumUnion of(EnumDer1 value) {
        return new UnionEnumUnion(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public UnionEnumUnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Returns the attribute enumDer1.
     *
     * @return enumDer1 value of enumDer1
     */
    public EnumDer1 enumDer1() {
        return enumDer1;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(UnionEnumUnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }
    /**
     * Sets the attribute enumDer1.
     *
     * @param enumDer1 value of enumDer1
     */
    public void enumDer1(EnumDer1 enumDer1) {
        this.enumDer1 = enumDer1;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration, enumDer1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnionEnumUnion) {
            UnionEnumUnion other = (UnionEnumUnion) obj;
            return
                Objects.equals(enumeration, other.enumeration) &&
                Objects.equals(enumDer1, other.enumDer1);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return enumeration.toString();
        }
        if (setValue.get(1)) {
            return enumDer1.toString();
        }
        return null;
    }
    /**
     * Returns the object of unionEnumUnion fromString input String unionEnumUnion.
     *
     * @param valInString value of input String
     * @return unionEnumUnion
     */
    public static UnionEnumUnion fromString(String valInString) {
        try {
            UnionEnumUnionEnum1 tmpVal = UnionEnumUnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            EnumDer1 tmpVal = EnumDer1.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
