/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.contenttest;

import java.util.List;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.ContentTest;
import org.onosproject.yang.gen.v1.ytbchoicewithcontainerandleaflist.rev20160826.ytbchoicewithcontainerandleaflist.contenttest.valid.Validlistincase;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of valid.
 */
public interface Valid extends ContentTest, Augmentable  {

    /**
     * Returns the attribute validlistincase.
     *
     * @return validlistincase list of validlistincase
     */
    List<Validlistincase> validlistincase();

    /**
     * Sets the attribute validlistincase.
     *
     * @param validlistincase list of validlistincase
     */
    void validlistincase(List<Validlistincase> validlistincase);

    /**
     * Adds to the list of validlistincase.
     *
     * @param addTo value of validlistincase
     */
    void addToValidlistincase(Validlistincase addTo);

}