/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbaugmentfromanotherfile.rev20160826.ytbaugmentfromanotherfile.networks.network.node.augmentedndnode;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of terminationPoint.
 */
public class TerminationPointKeys implements KeyInfo<DefaultTerminationPoint> {
    protected String tpId;
    /**
     * Returns the attribute tpId.
     *
     * @return tpId value of tpId
     */
    public String tpId() {
        return tpId;
    }

    /**
     * Sets the value to attribute tpId.
     *
     * @param tpId value of tpId
     */
    public void tpId(String tpId) {
        this.tpId = tpId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(tpId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TerminationPointKeys) {
            TerminationPointKeys other = (TerminationPointKeys) obj;
            return
                Objects.equals(tpId, other.tpId);
        }
        return false;
    }
}