/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.node.augmentedndnode.Tpoint;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedNdNode.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedNdNode extends InnerModelObject implements AugmentedNdNode {
    protected List<Tpoint> tPoint;

    @Override
    public List<Tpoint> tPoint() {
        return tPoint;
    }

    @Override
    public void tPoint(List<Tpoint> tPoint) {
        this.tPoint = tPoint;
    }

    @Override
    public void addToTpoint(Tpoint addTo) {
        if (tPoint == null) {
            tPoint = new ArrayList<>();
        }
        tPoint.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedNdNode) {
            DefaultAugmentedNdNode other = (DefaultAugmentedNdNode) obj;
            return
                Objects.equals(tPoint, other.tPoint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tPoint=" + tPoint)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedNdNode.
     */
    public DefaultAugmentedNdNode() {
    }

}