/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.networks.network.augmentedndnetwork.link;

import org.onosproject.yang.gen.v1.yrtietfnetwork.rev20151208.yrtietfnetwork.NetworkId;
import org.onosproject.yang.gen.v1.yrtnetworktopology.rev20151208.yrtnetworktopology.LinkId;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of supportingLink.
 */
public class SupportingLinkKeys implements KeyInfo<DefaultSupportingLink> {
    protected NetworkId networkRef;
    protected LinkId linkRef;
    /**
     * Returns the attribute networkRef.
     *
     * @return networkRef value of networkRef
     */
    public NetworkId networkRef() {
        return networkRef;
    }

    /**
     * Sets the value to attribute networkRef.
     *
     * @param networkRef value of networkRef
     */
    public void networkRef(NetworkId networkRef) {
        this.networkRef = networkRef;
    }

    /**
     * Returns the attribute linkRef.
     *
     * @return linkRef value of linkRef
     */
    public LinkId linkRef() {
        return linkRef;
    }

    /**
     * Sets the value to attribute linkRef.
     *
     * @param linkRef value of linkRef
     */
    public void linkRef(LinkId linkRef) {
        this.linkRef = linkRef;
    }


    @Override
    public int hashCode() {
        return Objects.hash(networkRef, linkRef);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SupportingLinkKeys) {
            SupportingLinkKeys other = (SupportingLinkKeys) obj;
            return
                Objects.equals(networkRef, other.networkRef) &&
                Objects.equals(linkRef, other.linkRef);
        }
        return false;
    }
}