/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of zeroBasedCounter32.
 */
public final class ZeroBasedCounter32 {

    private Counter32 counter32;

    /**
     * Creates an instance of zeroBasedCounter32.
     */
    private ZeroBasedCounter32() {
    }

    /**
     * Creates an instance of counter32.
     *
     * @param counter32 value of counter32
     */
    public ZeroBasedCounter32(Counter32 counter32) {
        this.counter32 = counter32;
    }

    /**
     * Returns the object of zeroBasedCounter32 for type counter32.
     *
     * @param value value of zeroBasedCounter32 for type counter32
     * @return zeroBasedCounter32 for type counter32
     */
    public static ZeroBasedCounter32 of(Counter32 value) {
        return new ZeroBasedCounter32(value);
    }

    /**
     * Returns the attribute counter32.
     *
     * @return counter32 value of counter32
     */
    public Counter32 counter32() {
        return counter32;
    }
    /**
     * Sets the attribute counter32.
     *
     * @param counter32 value of counter32
     */
    public void counter32(Counter32 counter32) {
        this.counter32 = counter32;
    }

    @Override
    public int hashCode() {
        return Objects.hash(counter32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ZeroBasedCounter32) {
            ZeroBasedCounter32 other = (ZeroBasedCounter32) obj;
            return
                Objects.equals(counter32, other.counter32);
        }
        return false;
    }

    @Override
    public String toString() {
        return counter32.toString();
    }
    /**
     * Returns the object of zeroBasedCounter32 fromString input String zeroBasedCounter32.
     *
     * @param valInString value of input String
     * @return zeroBasedCounter32
     */
    public static ZeroBasedCounter32 fromString(String valInString) {
        try {
            Counter32 tmpVal = Counter32.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
