/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of timestamp.
 */
public final class Timestamp {

    private Timeticks timeticks;

    /**
     * Creates an instance of timestamp.
     */
    private Timestamp() {
    }

    /**
     * Creates an instance of timeticks.
     *
     * @param timeticks value of timeticks
     */
    public Timestamp(Timeticks timeticks) {
        this.timeticks = timeticks;
    }

    /**
     * Returns the object of timestamp for type timeticks.
     *
     * @param value value of timestamp for type timeticks
     * @return timestamp for type timeticks
     */
    public static Timestamp of(Timeticks value) {
        return new Timestamp(value);
    }

    /**
     * Returns the attribute timeticks.
     *
     * @return timeticks value of timeticks
     */
    public Timeticks timeticks() {
        return timeticks;
    }
    /**
     * Sets the attribute timeticks.
     *
     * @param timeticks value of timeticks
     */
    public void timeticks(Timeticks timeticks) {
        this.timeticks = timeticks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(timeticks);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Timestamp) {
            Timestamp other = (Timestamp) obj;
            return
                Objects.equals(timeticks, other.timeticks);
        }
        return false;
    }

    @Override
    public String toString() {
        return timeticks.toString();
    }
    /**
     * Returns the object of timestamp fromString input String timestamp.
     *
     * @param valInString value of input String
     * @return timestamp
     */
    public static Timestamp fromString(String valInString) {
        try {
            Timeticks tmpVal = Timeticks.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
