/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes;

import java.util.Objects;

/**
 * Represents the implementation of objectIdentifier128.
 */
public final class ObjectIdentifier128 {

    private ObjectIdentifier objectIdentifier;

    /**
     * Creates an instance of objectIdentifier128.
     */
    private ObjectIdentifier128() {
    }

    /**
     * Creates an instance of objectIdentifier.
     *
     * @param objectIdentifier value of objectIdentifier
     */
    public ObjectIdentifier128(ObjectIdentifier objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    /**
     * Returns the object of objectIdentifier128 for type objectIdentifier.
     *
     * @param value value of objectIdentifier128 for type objectIdentifier
     * @return objectIdentifier128 for type objectIdentifier
     */
    public static ObjectIdentifier128 of(ObjectIdentifier value) {
        return new ObjectIdentifier128(value);
    }

    /**
     * Returns the attribute objectIdentifier.
     *
     * @return objectIdentifier value of objectIdentifier
     */
    public ObjectIdentifier objectIdentifier() {
        return objectIdentifier;
    }
    /**
     * Sets the attribute objectIdentifier.
     *
     * @param objectIdentifier value of objectIdentifier
     */
    public void objectIdentifier(ObjectIdentifier objectIdentifier) {
        this.objectIdentifier = objectIdentifier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(objectIdentifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ObjectIdentifier128) {
            ObjectIdentifier128 other = (ObjectIdentifier128) obj;
            return
                Objects.equals(objectIdentifier, other.objectIdentifier);
        }
        return false;
    }

    @Override
    public String toString() {
        return objectIdentifier.toString();
    }
    /**
     * Returns the object of objectIdentifier128 fromString input String objectIdentifier128.
     *
     * @param valInString value of input String
     * @return objectIdentifier128
     */
    public static ObjectIdentifier128 fromString(String valInString) {
        try {
            ObjectIdentifier tmpVal = ObjectIdentifier.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
