/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;
/**
 * Represents the implementation of lspProtUnidir1To1.
 */
public abstract class LspProtUnidir1To1 {

    /**
     * Returns the attribute lsp-prot-unidir-1-to-1.
     *
     * @return lsp-prot-unidir-1-to-1 value of lsp-prot-unidir-1-to-1
     */
    public static String lspProtUnidir1To1ToString() {
        return "lsp-prot-unidir-1-to-1";
    }

    /**
     * Returns the object of lspProtUnidir1To1 fromString input String lspProtUnidir1To1.
     *
     * @param valInString value of input String
     * @return lspProtUnidir1To1
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("lsp-prot-unidir-1-to-1")) {
            return LspProtUnidir1To1.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}